/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationFilter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.lwjgl.util.generator.ContextCapabilitiesGenerator;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextGeneratorProcessorFactory
implements AnnotationProcessorFactory,
RoundCompleteListener {
    private static boolean first_round = true;
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("*"));

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return Collections.unmodifiableCollection(Arrays.asList("-Acontextspecific"));
    }

    public void roundComplete(RoundCompleteEvent event) {
        first_round = false;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        if (first_round) {
            env.addListener((AnnotationProcessorListener)this);
            return new GeneratorProcessor(env);
        }
        return AnnotationProcessors.NO_OP;
    }

    private static class GeneratorProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;

        GeneratorProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            Map options = this.env.getOptions();
            boolean context_specific = options.containsKey("-Acontextspecific");
            try {
                this.generateContextCapabilitiesSource(context_specific);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void generateContextCapabilitiesSource(boolean context_specific) throws IOException {
            InterfaceDeclaration interface_decl;
            PrintWriter writer = this.env.getFiler().createTextFile(Filer.Location.SOURCE_TREE, "org.lwjgl.opengl", new File("ContextCapabilities.java"), null);
            writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
            writer.println();
            writer.println("package org.lwjgl.opengl;");
            writer.println();
            writer.println("import org.lwjgl.LWJGLException;");
            writer.println("import org.lwjgl.BufferUtils;");
            writer.println("import java.util.Set;");
            writer.println("import java.nio.IntBuffer;");
            writer.println();
            ContextCapabilitiesGenerator.generateClassPrologue(writer, context_specific);
            DeclarationFilter filter = DeclarationFilter.getFilter(InterfaceDeclaration.class);
            Collection interface_decls = filter.filter(this.env.getSpecifiedTypeDeclarations());
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                if (!Utils.isFinal(interface_decl)) continue;
                ContextCapabilitiesGenerator.generateField(writer, interface_decl);
            }
            writer.println();
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                ContextCapabilitiesGenerator.generateSymbolAddresses(writer, interface_decl);
            }
            writer.println();
            if (context_specific) {
                for (TypeDeclaration typedecl : interface_decls) {
                    interface_decl = (InterfaceDeclaration)typedecl;
                    ContextCapabilitiesGenerator.generateAddressesInitializers(writer, interface_decl);
                }
                writer.println();
            }
            ContextCapabilitiesGenerator.generateInitStubsPrologue(writer, context_specific);
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                if (Utils.isFinal(interface_decl)) continue;
                ContextCapabilitiesGenerator.generateAddExtension(writer, interface_decl);
            }
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                String simple_name = interface_decl.getSimpleName();
                if (simple_name.equals("GL11")) continue;
                ContextCapabilitiesGenerator.generateInitStubs(writer, interface_decl, context_specific);
            }
            ContextCapabilitiesGenerator.generateInitStubsEpilogue(writer, context_specific);
            writer.println();
            writer.println("\tstatic void unloadAllStubs() {");
            if (!context_specific) {
                writer.println("\t\tif (!loaded_stubs)");
                writer.println("\t\t\treturn;");
                for (TypeDeclaration typedecl : interface_decls) {
                    interface_decl = (InterfaceDeclaration)typedecl;
                    ContextCapabilitiesGenerator.generateUnloadStubs(writer, interface_decl);
                }
                writer.println("\t\tloaded_stubs = false;");
            }
            writer.println("\t}");
            writer.println();
            ContextCapabilitiesGenerator.generateInitializerPrologue(writer);
            for (TypeDeclaration typedecl : interface_decls) {
                interface_decl = (InterfaceDeclaration)typedecl;
                if (!Utils.isFinal(interface_decl)) continue;
                ContextCapabilitiesGenerator.generateInitializer(writer, interface_decl);
            }
            writer.println("\t}");
            writer.println("}");
            writer.close();
        }
    }
}

