/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.type.InterfaceType;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.lwjgl.util.generator.Platform;
import org.lwjgl.util.generator.PlatformDependent;
import org.lwjgl.util.generator.Utils;

public class ContextCapabilitiesGenerator {
    private static final String STUBS_LOADED_NAME = "loaded_stubs";
    private static final String ALL_INIT_METHOD_NAME = "initAllStubs";
    private static final String POINTER_INITIALIZER_POSTFIX = "_initNativeFunctionAddresses";
    private static final String CACHED_EXTS_VAR_NAME = "supported_extensions";
    private static final String EXTENSION_PREFIX = "GL_";
    private static final String CORE_PREFIX = "Open";

    public static void generateClassPrologue(PrintWriter writer, boolean context_specific) {
        writer.println("public class ContextCapabilities {");
        writer.println("\tfinal StateTracker tracker;");
        writer.println("\tfinal IntBuffer scratch_int_buffer = BufferUtils.createIntBuffer(16);");
        writer.println();
        if (!context_specific) {
            writer.println("\tprivate static boolean loaded_stubs = false;");
        }
    }

    public static void generateInitializerPrologue(PrintWriter writer) {
        writer.println("\tContextCapabilities() throws LWJGLException {");
        writer.println("\t\tSet supported_extensions = initAllStubs();");
        writer.println("\t\ttracker = new StateTracker();");
    }

    private static String translateFieldName(String interface_name) {
        if (interface_name.startsWith("GL")) {
            return CORE_PREFIX + interface_name;
        }
        return EXTENSION_PREFIX + interface_name;
    }

    public static void generateInitializer(PrintWriter writer, InterfaceDeclaration d) {
        String translated_field_name = ContextCapabilitiesGenerator.translateFieldName(d.getSimpleName());
        writer.print("\t\tthis." + translated_field_name + " = ");
        writer.print("supported_extensions.contains(\"");
        writer.print(translated_field_name + "\")");
        Collection super_interfaces = d.getSuperinterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one other interface");
        }
        if (super_interfaces.size() == 1) {
            InterfaceType super_interface = (InterfaceType)super_interfaces.iterator().next();
            writer.println();
            writer.print("\t\t\t&& supported_extensions.contains(\"");
            writer.print(ContextCapabilitiesGenerator.translateFieldName(super_interface.getDeclaration().getSimpleName()) + "\")");
        }
        writer.println(";");
    }

    private static String getAddressesInitializerName(String class_name) {
        return class_name + POINTER_INITIALIZER_POSTFIX;
    }

    public static void generateInitStubsPrologue(PrintWriter writer, boolean context_specific) {
        writer.println("\tprivate Set initAllStubs() throws LWJGLException {");
        if (!context_specific) {
            writer.println("\t\tif (loaded_stubs)");
            writer.println("\t\t\treturn GLContext.getSupportedExtensions();");
            writer.println("\t\torg.lwjgl.opengl.GL11.initNativeStubs();");
        } else {
            writer.println("\t\tif (!" + ContextCapabilitiesGenerator.getAddressesInitializerName("GL11") + "())");
            writer.println("\t\t\tthrow new LWJGLException(\"GL11 not supported\");");
        }
        writer.println("\t\tGLContext.setCapabilities(this);");
        writer.println("\t\tSet supported_extensions = GLContext.getSupportedExtensions();");
    }

    public static void generateInitStubsEpilogue(PrintWriter writer, boolean context_specific) {
        if (!context_specific) {
            writer.println("\t\tloaded_stubs = true;");
        }
        writer.println("\t\treturn supported_extensions;");
        writer.println("\t}");
    }

    public static void generateUnloadStubs(PrintWriter writer, InterfaceDeclaration d) {
        if (d.getMethods().size() > 0) {
            writer.print("\t\tGLContext.resetNativeStubs(" + Utils.getSimpleClassName(d));
            writer.println(".class);");
        }
    }

    public static void generateInitStubs(PrintWriter writer, InterfaceDeclaration d, boolean context_specific) {
        if (d.getMethods().size() > 0) {
            if (context_specific) {
                writer.print("\t\tif (supported_extensions.contains(\"");
                writer.print(ContextCapabilitiesGenerator.translateFieldName(d.getSimpleName()) + "\")");
                writer.println(" && !" + ContextCapabilitiesGenerator.getAddressesInitializerName(d.getSimpleName()) + "())");
                writer.print("\t\t\tsupported_extensions.remove(\"");
                writer.println(ContextCapabilitiesGenerator.translateFieldName(d.getSimpleName()) + "\");");
            } else {
                writer.print("\t\tGLContext.initNativeStubs(" + Utils.getSimpleClassName(d));
                writer.println(".class, supported_extensions, \"" + ContextCapabilitiesGenerator.translateFieldName(d.getSimpleName()) + "\");");
            }
        }
    }

    public static void generateAddExtension(PrintWriter writer, InterfaceDeclaration d) {
        writer.print("\t\tsupported_extensions.add(\"");
        writer.println(ContextCapabilitiesGenerator.translateFieldName(d.getSimpleName()) + "\");");
    }

    public static void generateAddressesInitializers(PrintWriter writer, InterfaceDeclaration d) {
        Iterator methods = d.getMethods().iterator();
        if (methods.hasNext()) {
            writer.println("\tprivate boolean " + ContextCapabilitiesGenerator.getAddressesInitializerName(d.getSimpleName()) + "() {");
            writer.println("\t\treturn ");
            while (methods.hasNext()) {
                MethodDeclaration method = (MethodDeclaration)methods.next();
                writer.print("\t\t\t(" + Utils.getFunctionAddressName(d, method) + " = ");
                PlatformDependent platform_dependent = (PlatformDependent)method.getAnnotation(PlatformDependent.class);
                if (platform_dependent != null) {
                    EnumSet<Platform> platform_set = EnumSet.copyOf(Arrays.asList(platform_dependent.value()));
                    writer.print("GLContext.getPlatformSpecificFunctionAddress(\"");
                    writer.print(Platform.ALL.getPrefix() + "\", ");
                    writer.print("new String[]{");
                    Iterator platforms = platform_set.iterator();
                    while (platforms.hasNext()) {
                        writer.print("\"" + ((Platform)((Object)platforms.next())).getOSPrefix() + "\"");
                        if (!platforms.hasNext()) continue;
                        writer.print(", ");
                    }
                    writer.print("}, new String[]{");
                    platforms = platform_set.iterator();
                    while (platforms.hasNext()) {
                        writer.print("\"" + ((Platform)((Object)platforms.next())).getPrefix() + "\"");
                        if (!platforms.hasNext()) continue;
                        writer.print(", ");
                    }
                    writer.print("}, ");
                } else {
                    writer.print("GLContext.getFunctionAddress(");
                }
                writer.print("\"" + method.getSimpleName() + "\")) != 0");
                if (!methods.hasNext()) continue;
                writer.println(" &&");
            }
            writer.println(";");
            writer.println("\t}");
            writer.println();
        }
    }

    public static void generateSymbolAddresses(PrintWriter writer, InterfaceDeclaration d) {
        for (MethodDeclaration method : d.getMethods()) {
            writer.println("\tlong " + Utils.getFunctionAddressName(d, method) + ";");
        }
    }

    public static void generateField(PrintWriter writer, InterfaceDeclaration d) {
        writer.println("\tpublic final boolean " + ContextCapabilitiesGenerator.translateFieldName(d.getSimpleName()) + ";");
    }
}

