/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.type.PrimitiveType;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.util.generator.ALboolean;
import org.lwjgl.util.generator.ALbyte;
import org.lwjgl.util.generator.ALdouble;
import org.lwjgl.util.generator.ALenum;
import org.lwjgl.util.generator.ALfloat;
import org.lwjgl.util.generator.ALint;
import org.lwjgl.util.generator.ALshort;
import org.lwjgl.util.generator.ALsizei;
import org.lwjgl.util.generator.ALubyte;
import org.lwjgl.util.generator.ALuint;
import org.lwjgl.util.generator.ALvoid;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;

public class ALTypeMap
implements TypeMap {
    private static final Map<Class, PrimitiveType.Kind> native_types_to_primitive = new HashMap<Class, PrimitiveType.Kind>();

    public PrimitiveType.Kind getPrimitiveTypeFromNativeType(Class native_type) {
        PrimitiveType.Kind kind = native_types_to_primitive.get(native_type);
        if (kind == null) {
            throw new RuntimeException("Unsupported type " + native_type);
        }
        return kind;
    }

    public Signedness getSignednessFromType(Class type) {
        if (ALuint.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (ALint.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (ALshort.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (ALbyte.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        return Signedness.NONE;
    }

    public String translateAnnotation(Class annotation_type) {
        if (annotation_type.equals(ALuint.class)) {
            return "i";
        }
        if (annotation_type.equals(ALint.class)) {
            return "i";
        }
        if (annotation_type.equals(ALshort.class)) {
            return "s";
        }
        if (annotation_type.equals(ALbyte.class)) {
            return "b";
        }
        if (annotation_type.equals(ALfloat.class)) {
            return "f";
        }
        if (annotation_type.equals(ALdouble.class)) {
            return "d";
        }
        if (annotation_type.equals(ALboolean.class) || annotation_type.equals(ALvoid.class)) {
            return "";
        }
        throw new RuntimeException(annotation_type + " is not allowed");
    }

    public Class getNativeTypeFromPrimitiveType(PrimitiveType.Kind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = ALint.class;
                break;
            }
            case FLOAT: {
                type = ALfloat.class;
                break;
            }
            case DOUBLE: {
                type = ALdouble.class;
                break;
            }
            case SHORT: {
                type = ALshort.class;
                break;
            }
            case BYTE: {
                type = ALbyte.class;
                break;
            }
            case BOOLEAN: {
                type = ALboolean.class;
                break;
            }
            default: {
                throw new RuntimeException(kind + " is not allowed");
            }
        }
        return type;
    }

    private static Class[] getValidBufferTypes(Class type) {
        if (type.equals(IntBuffer.class)) {
            return new Class[]{ALenum.class, ALint.class, ALsizei.class, ALuint.class};
        }
        if (type.equals(FloatBuffer.class)) {
            return new Class[]{ALfloat.class};
        }
        if (type.equals(ByteBuffer.class)) {
            return new Class[]{ALboolean.class, ALbyte.class, ALvoid.class};
        }
        if (type.equals(ShortBuffer.class)) {
            return new Class[]{ALshort.class};
        }
        if (type.equals(DoubleBuffer.class)) {
            return new Class[]{ALdouble.class};
        }
        return new Class[0];
    }

    private static Class[] getValidPrimitiveTypes(Class type) {
        if (type.equals(Integer.TYPE)) {
            return new Class[]{ALenum.class, ALint.class, ALsizei.class, ALuint.class};
        }
        if (type.equals(Double.TYPE)) {
            return new Class[]{ALdouble.class};
        }
        if (type.equals(Float.TYPE)) {
            return new Class[]{ALfloat.class};
        }
        if (type.equals(Short.TYPE)) {
            return new Class[]{ALshort.class};
        }
        if (type.equals(Byte.TYPE)) {
            return new Class[]{ALbyte.class};
        }
        if (type.equals(Boolean.TYPE)) {
            return new Class[]{ALboolean.class};
        }
        if (type.equals(Void.TYPE)) {
            return new Class[]{ALvoid.class};
        }
        return new Class[0];
    }

    public String getErrorCheckMethodName() {
        return "Util.checkALError()";
    }

    public String getRegisterNativesFunctionName() {
        return "extal_InitializeClass";
    }

    public String getTypedefPrefix() {
        return "ALAPIENTRY";
    }

    public void printNativeIncludes(PrintWriter writer) {
        writer.println("#include \"extal.h\"");
    }

    public Class getStringElementType() {
        return ALubyte.class;
    }

    public Class[] getValidAnnotationTypes(Class type) {
        Class[] valid_types = Buffer.class.isAssignableFrom(type) ? ALTypeMap.getValidBufferTypes(type) : (type.isPrimitive() ? ALTypeMap.getValidPrimitiveTypes(type) : (type.equals(String.class) ? new Class[]{ALubyte.class} : new Class[]{}));
        return valid_types;
    }

    public Class getVoidType() {
        return ALvoid.class;
    }

    public Class getInverseType(Class type) {
        if (ALuint.class.equals((Object)type)) {
            return ALint.class;
        }
        if (ALint.class.equals((Object)type)) {
            return ALuint.class;
        }
        return null;
    }

    public String getAutoTypeFromAnnotation(AnnotationMirror annotation) {
        return null;
    }

    static {
        native_types_to_primitive.put(ALboolean.class, PrimitiveType.Kind.BOOLEAN);
        native_types_to_primitive.put(ALbyte.class, PrimitiveType.Kind.BYTE);
        native_types_to_primitive.put(ALenum.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(ALfloat.class, PrimitiveType.Kind.FLOAT);
        native_types_to_primitive.put(ALdouble.class, PrimitiveType.Kind.DOUBLE);
        native_types_to_primitive.put(ALint.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(ALshort.class, PrimitiveType.Kind.SHORT);
        native_types_to_primitive.put(ALsizei.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(ALubyte.class, PrimitiveType.Kind.BYTE);
        native_types_to_primitive.put(ALuint.class, PrimitiveType.Kind.INT);
        native_types_to_primitive.put(ALvoid.class, PrimitiveType.Kind.BYTE);
    }
}

