/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class XPMFile {
    private byte[] bytes = null;
    private int height = 0;
    private int width = 0;

    private XPMFile() {
    }

    public static XPMFile load(String file) throws IOException {
        return XPMFile.load(new FileInputStream(new File(file)));
    }

    public static XPMFile load(InputStream is) throws IOException {
        XPMFile xFile = new XPMFile();
        xFile.readImage(is);
        return xFile;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    private void readImage(InputStream is) throws IOException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            HashMap<Object, Object> colors = new HashMap<Object, Object>();
            String comment = br.readLine();
            String typedef = br.readLine();
            int[] format = this.parseFormat(br.readLine());
            int i = 0;
            while (i < format[2]) {
                Object[] colorDefinition = this.parseColor(br.readLine());
                colors.put(colorDefinition[0], colorDefinition[1]);
                ++i;
            }
            this.bytes = new byte[format[0] * format[1] * 4];
            i = 0;
            while (i < format[1]) {
                this.parseImageLine(br.readLine(), format, colors, i);
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse XPM File");
        }
    }

    private int[] parseFormat(String format) {
        format = format.substring(1, format.length() - 2);
        StringTokenizer st = new StringTokenizer(format);
        return new int[]{Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())};
    }

    private Object[] parseColor(String line) {
        line = line.substring(1, line.length() - 2);
        String key = line.substring(0, 2);
        String type = line.substring(3, 4);
        String color = line.substring(6);
        return new Object[]{key, new Integer(Integer.parseInt(color, 16))};
    }

    private void parseImageLine(String line, int[] format, HashMap colors, int index) {
        int offset = index * 4 * format[0];
        line = line.substring(1, line.length());
        int i = 0;
        while (i < format[0]) {
            String key = line.substring(i * 2, i * 2 + 2);
            Integer color = (Integer)colors.get(key);
            this.bytes[offset + i * 4] = (byte)((color & 0xFF0000) >> 16);
            this.bytes[offset + (i * 4 + 1)] = (byte)((color & 0xFF00) >> 8);
            this.bytes[offset + (i * 4 + 2)] = (byte)((color & 0xFF) >> 0);
            this.bytes[offset + (i * 4 + 3)] = -1;
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage:\nXPMFile <file>");
        }
        try {
            String out = String.valueOf(args[0].substring(0, args[0].indexOf("."))) + ".raw";
            XPMFile file = XPMFile.load(args[0]);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(out)));
            bos.write(file.getBytes());
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

