/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import java.io.Serializable;

public class Score
implements Serializable,
Comparable {
    private static final long serialVersionUID = 2L;
    public static final int MAX_LENGTH = 24;
    private int rank;
    private final int points;
    private String name;
    private String group;
    private final long installation;
    private String medals;
    private String game;
    private boolean registered;

    public Score(String game, String group, String name, long installation, int points, String medals, boolean registered) {
        this.game = game;
        this.group = "".equals(group) ? null : group;
        this.installation = installation;
        this.points = points;
        if (name != null) {
            this.setName(name);
        }
        if (medals == null) {
            medals = "";
        }
        this.medals = medals;
        this.registered = registered;
    }

    public void setName(String name) {
        this.name = name.length() > 24 ? name.substring(0, 24) : name;
    }

    public String getName() {
        return this.name;
    }

    public int getPoints() {
        return this.points;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof Score)) {
            return -1;
        }
        Score score = (Score)obj;
        if (score.points < this.points) {
            return -1;
        }
        if (score.points == this.points) {
            return 0;
        }
        return 1;
    }

    public boolean like(Score s) {
        return s.game.equals(this.game) && s.installation == this.installation && s.name.equals(this.name) && (s.group == null && this.group == null || s.group != null && s.group.equals(this.group));
    }

    public String toString() {
        return "Score[" + this.game + ", " + this.group + ", " + this.name + ", " + this.medals + ", " + this.points + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Score)) {
            return false;
        }
        Score s = (Score)obj;
        return s.game.equals(this.game) && s.installation == this.installation && s.medals.equals(this.medals) && s.name.equals(this.name) && (s.group == null && this.group == null || s.group != null && s.group.equals(this.group)) && s.points == this.points;
    }

    public int hashCode() {
        return this.game.hashCode() ^ this.points ^ (int)this.installation ^ this.name.hashCode() ^ this.medals.hashCode() ^ (this.group == null ? 0 : this.group.hashCode());
    }

    public long getInstallation() {
        return this.installation;
    }

    public String getMedals() {
        return this.medals;
    }

    public String getGame() {
        return this.game;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isRegistered() {
        return this.registered;
    }
}

