/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.puppygames.applet.Screen;
import net.puppygames.applet.widgets.PowerDisplay;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public class PowerDisplayFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private int gap;
    private Point location = new Point(0, 0);
    private int layer;
    private List bars;

    public PowerDisplayFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public PowerDisplayFeature() {
        this.setAutoCreated();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List barElements = XMLUtil.getChildren((Element)element, (String)"bar");
        this.bars = new ArrayList(barElements.size());
        Iterator i = barElements.iterator();
        while (i.hasNext()) {
            Element barElement = (Element)i.next();
            BarFeature bf = new BarFeature();
            bf.load(barElement, loader);
            this.bars.add(bf);
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        Iterator i = this.bars.iterator();
        while (i.hasNext()) {
            BarFeature bar = (BarFeature)((Object)i.next());
            bar.create();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        Iterator i = this.bars.iterator();
        while (i.hasNext()) {
            BarFeature bar = (BarFeature)((Object)i.next());
            bar.destroy();
        }
    }

    public PowerDisplay spawn(Screen screen) {
        PowerDisplay ret = new PowerDisplay(){
            BarFeature.BarInstance[] bar;
            int x;
            int y;
            int used = -1;
            boolean visible = true;

            public void setVisible(boolean visible) {
                this.visible = visible;
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].sprite.setVisible(visible);
                    ++i;
                }
            }

            public void setUsed(int used) {
                if (this.used == used) {
                    return;
                }
                this.used = used;
                int i = 0;
                while (i < Math.min(this.bar.length, used)) {
                    this.bar[i].setUsed(true);
                    ++i;
                }
                i = Math.max(0, used);
                while (i < this.bar.length) {
                    this.bar[i].setUsed(false);
                    ++i;
                }
            }

            public void setLocation(int x, int y) {
                this.x = x;
                this.y = y;
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].setLocation(x, y);
                    int g = this.bar[i].getGap();
                    if (g == 0) {
                        g = PowerDisplayFeature.this.gap;
                    }
                    x += g;
                    ++i;
                }
            }

            public void setAlpha(int alpha) {
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].sprite.setAlpha(alpha);
                    ++i;
                }
            }

            public int getBarAt(int xx, int yy) {
                if (!PowerDisplayFeature.this.bounds.contains(xx, yy)) {
                    return -1;
                }
                return this.getMax() * (xx - PowerDisplayFeature.this.bounds.getX()) / PowerDisplayFeature.this.bounds.getWidth();
            }

            public void init(Screen screen) {
                this.bar = new BarFeature.BarInstance[PowerDisplayFeature.this.bars.size()];
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i] = ((BarFeature)((Object)PowerDisplayFeature.this.bars.get(i))).init(PowerDisplayFeature.this, screen);
                    ++i;
                }
            }

            public void cleanup() {
                if (this.bar == null) {
                    return;
                }
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].cleanup();
                    ++i;
                }
                this.bar = null;
            }

            public int getUsed() {
                return this.used;
            }

            public int getMax() {
                return PowerDisplayFeature.this.bars.size();
            }
        };
        ret.init(screen);
        ret.setLocation(this.location.getX(), this.location.getY());
        ret.setUsed(0);
        return ret;
    }

    public int getTotalBars() {
        return this.bars.size();
    }

    private static class BarFeature
    extends Feature {
        private String on;
        private String off;
        private int width;
        private transient AnimatedAppearanceResource onResource;
        private transient AnimatedAppearanceResource offResource;

        BarFeature() {
            this.setAutoCreated();
            this.setSubResource(true);
        }

        BarInstance init(PowerDisplayFeature feature, Screen screen) {
            BarInstance ret = new BarInstance();
            ret.init(feature, screen);
            return ret;
        }

        private class BarInstance {
            Sprite sprite;

            BarInstance() {
            }

            void init(PowerDisplayFeature feature, Screen screen) {
                this.sprite = screen.allocateSprite(this);
                if (this.sprite == null) {
                    return;
                }
                this.sprite.setLayer(feature.layer);
            }

            void cleanup() {
                if (this.sprite != null) {
                    this.sprite.deallocate();
                    this.sprite = null;
                }
            }

            void setUsed(boolean used) {
                if (used) {
                    this.sprite.setAppearance((AnimatedAppearance)BarFeature.this.onResource);
                    this.sprite.setVisible(true);
                } else if (BarFeature.this.offResource == null) {
                    this.sprite.setVisible(false);
                } else {
                    this.sprite.setAppearance((AnimatedAppearance)BarFeature.this.offResource);
                }
            }

            void setLocation(int x, int y) {
                this.sprite.setLocation(x, y, 0);
            }

            int getGap() {
                return BarFeature.this.width;
            }
        }
    }
}

