/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import net.puppygames.applet.Game;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public abstract class SimpleBaseEffect
extends Effect {
    private static final Color cachedColor = new Color();
    private int duration;
    private int fadeDuration;
    private int tick;
    private int fadeTick;
    private float hue;
    private boolean coloured;
    private float x;
    private float y;
    private int width;
    private int height;
    private float vx;
    private float vy;
    private float ax;
    private float ay;
    private boolean finished;
    private boolean visible = true;
    private ReadableColor startColor;
    private ReadableColor endColor;

    public SimpleBaseEffect(ReadableColor startColor, ReadableColor endColor, int duration, int fadeDuration) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
    }

    public static Color getCachedColor() {
        return cachedColor;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    protected final void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final boolean isActive() {
        return this.fadeTick <= this.fadeDuration;
    }

    public final void setColoured(boolean coloured) {
        this.coloured = coloured;
    }

    public final boolean isColoured() {
        return this.coloured;
    }

    protected final void doTick() {
        this.setLocation(this.x + this.vx, this.y + this.vy);
        this.vx += this.ax;
        this.vy += this.ay;
        this.doSimpleTick();
        if (this.finished) {
            ++this.fadeTick;
        } else {
            ++this.tick;
            if (this.tick >= this.duration && this.duration != 0 || this.x < (float)(-this.width / 2) || this.y < (float)(-this.height / 2) || this.x > (float)(Game.getWidth() + this.width / 2) || this.y > (float)(Game.getHeight() + this.height / 2)) {
                this.finished = true;
            } else if (this.coloured) {
                this.hue += 0.01f;
            }
        }
    }

    protected void doSimpleTick() {
    }

    public final void finish() {
        this.finished = true;
    }

    protected final void doRender() {
        if (this.finished) {
            float ratio = (float)this.fadeTick / (float)this.fadeDuration;
            cachedColor.set(this.endColor.getRed(), this.endColor.getGreen(), this.endColor.getBlue(), (int)(255.0f - 255.0f * ratio));
        } else {
            float ratio = (float)this.tick / (float)this.duration;
            ColorInterpolator.interpolate((ReadableColor)this.startColor, (ReadableColor)this.endColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (WritableColor)cachedColor);
        }
        this.doEffectRender();
    }

    protected abstract void doEffectRender();

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
        this.doSetLocation();
    }

    protected abstract void doSetLocation();

    public void setVelocity(float vx, float vy) {
        this.vx = vx;
        this.vy = vy;
    }

    public void setAcceleration(float ax, float ay) {
        this.ax = ax;
        this.ay = ay;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

