/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayMode;

public final class Display {
    private static final boolean DEBUG = false;

    public static DisplayMode[] getAvailableDisplayModes(int minWidth, int minHeight, int maxWidth, int maxHeight, int minBPP, int maxBPP, int minFreq, int maxFreq) throws LWJGLException {
        DisplayMode[] modes = org.lwjgl.opengl.Display.getAvailableDisplayModes();
        if (LWJGLUtil.DEBUG) {
            System.out.println("Available screen modes:");
            DisplayMode[] displayModeArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                DisplayMode mode = displayModeArray[n2];
                System.out.println(mode);
                ++n2;
            }
        }
        ArrayList<DisplayMode> matches = new ArrayList<DisplayMode>(modes.length);
        int i = 0;
        while (i < modes.length) {
            assert (modes[i] != null) : i + " " + modes.length;
            if (!(minWidth != -1 && modes[i].getWidth() < minWidth || maxWidth != -1 && modes[i].getWidth() > maxWidth || minHeight != -1 && modes[i].getHeight() < minHeight || maxHeight != -1 && modes[i].getHeight() > maxHeight || minBPP != -1 && modes[i].getBitsPerPixel() < minBPP || maxBPP != -1 && modes[i].getBitsPerPixel() > maxBPP || modes[i].getFrequency() != 0 && (minFreq != -1 && modes[i].getFrequency() < minFreq || maxFreq != -1 && modes[i].getFrequency() > maxFreq))) {
                matches.add(modes[i]);
            }
            ++i;
        }
        DisplayMode[] ret = new DisplayMode[matches.size()];
        matches.toArray(ret);
        return ret;
    }

    public static DisplayMode setDisplayMode(DisplayMode[] dm, String[] param) throws Exception {
        DisplayMode aDm;
        int n;
        int n2;
        DisplayMode[] displayModeArray;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Sorter
        implements Comparator<DisplayMode> {
            final 1FieldAccessor[] accessors;

            Sorter(String[] stringArray) {
                class FieldAccessor {
                    final String fieldName;
                    final int order;
                    final int preferred;
                    final boolean usePreferred;

                    FieldAccessor(String fieldName, int order, int preferred, boolean usePreferred) {
                        this.fieldName = fieldName;
                        this.order = order;
                        this.preferred = preferred;
                        this.usePreferred = usePreferred;
                    }

                    int getInt(DisplayMode mode) {
                        if ("width".equals(this.fieldName)) {
                            return mode.getWidth();
                        }
                        if ("height".equals(this.fieldName)) {
                            return mode.getHeight();
                        }
                        if ("freq".equals(this.fieldName)) {
                            return mode.getFrequency();
                        }
                        if ("bpp".equals(this.fieldName)) {
                            return mode.getBitsPerPixel();
                        }
                        throw new IllegalArgumentException("Unknown field " + this.fieldName);
                    }
                }
                this.accessors = new FieldAccessor[stringArray.length];
                int i = 0;
                while (i < this.accessors.length) {
                    int idx = stringArray[i].indexOf(61);
                    this.accessors[i] = idx > 0 ? new FieldAccessor(stringArray[i].substring(0, idx), 0, Integer.parseInt(stringArray[i].substring(idx + 1, stringArray[i].length())), true) : (stringArray[i].charAt(0) == '-' ? new FieldAccessor(stringArray[i].substring(1), -1, 0, false) : new FieldAccessor(stringArray[i], 1, 0, false));
                    ++i;
                }
            }

            @Override
            public int compare(DisplayMode dm1, DisplayMode dm2) {
                FieldAccessor[] fieldAccessorArray = this.accessors;
                int n = this.accessors.length;
                int n2 = 0;
                while (n2 < n) {
                    FieldAccessor accessor = fieldAccessorArray[n2];
                    int f1 = accessor.getInt(dm1);
                    int f2 = accessor.getInt(dm2);
                    if (accessor.usePreferred && f1 != f2) {
                        int absf2;
                        if (f1 == accessor.preferred) {
                            return -1;
                        }
                        if (f2 == accessor.preferred) {
                            return 1;
                        }
                        int absf1 = Math.abs(f1 - accessor.preferred);
                        if (absf1 < (absf2 = Math.abs(f2 - accessor.preferred))) {
                            return -1;
                        }
                        if (absf1 > absf2) {
                            return 1;
                        }
                    } else {
                        if (f1 < f2) {
                            return accessor.order;
                        }
                        if (f1 != f2) {
                            return -accessor.order;
                        }
                    }
                    ++n2;
                }
                return 0;
            }
        }
        Arrays.sort(dm, new Sorter(param));
        if (LWJGLUtil.DEBUG) {
            System.out.println("Sorted display modes:");
            displayModeArray = dm;
            n2 = dm.length;
            n = 0;
            while (n < n2) {
                aDm = displayModeArray[n];
                System.out.println(aDm);
                ++n;
            }
        }
        displayModeArray = dm;
        n2 = dm.length;
        n = 0;
        while (n < n2) {
            aDm = displayModeArray[n];
            try {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Attempting to set displaymode: " + aDm);
                }
                org.lwjgl.opengl.Display.setDisplayMode((DisplayMode)aDm);
                return aDm;
            }
            catch (Exception e) {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Failed to set display mode to " + aDm);
                    e.printStackTrace();
                }
                ++n;
            }
        }
        throw new Exception("Failed to set display mode.");
    }
}

