/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.vector;

import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import java.nio.IntBuffer;

public final class Vector3i
extends Vector
implements WritableVector3i {
    private static final long serialVersionUID = 1L;
    private int x;
    private int y;
    private int z;

    public Vector3i() {
    }

    public Vector3i(ReadableVector3i src) {
        this.set(src);
    }

    public Vector3i(int x, int y, int z) {
        this.set(x, y, z);
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(ReadableVector3i src) {
        this.set(src.getX(), src.getY(), src.getZ());
    }

    public long lengthSquared() {
        long lx = this.x;
        long ly = this.y;
        long lz = this.z;
        return lx * lx + ly * ly + lz * lz >> 16;
    }

    public void translate(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public static void add(ReadableVector3i left, ReadableVector3i right, WritableVector3i dest) {
        dest.set(left.getX() + right.getX(), left.getY() + right.getY(), left.getZ() + right.getZ());
    }

    public static void sub(ReadableVector3i left, ReadableVector3i right, WritableVector3i dest) {
        dest.set(left.getX() - right.getX(), left.getY() - right.getY(), left.getZ() - right.getZ());
    }

    public static void cross(ReadableVector3i left, ReadableVector3i right, WritableVector3i dest) {
        dest.set(FPMath.mul(left.getY(), right.getZ()) - FPMath.mul(left.getZ(), right.getY()), FPMath.mul(right.getX(), left.getZ()) - FPMath.mul(right.getZ(), left.getX()), FPMath.mul(left.getX(), right.getY()) - FPMath.mul(left.getY(), right.getX()));
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public void negate(WritableVector3i dest) {
        dest.set(-this.x, -this.y, -this.z);
    }

    public static int dot(ReadableVector3i left, ReadableVector3i right) {
        return left.getX() * right.getX() + left.getY() * right.getY() + left.getZ() * right.getZ() >> 16;
    }

    public void load(IntBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        this.z = buf.get();
    }

    public void scale(int scale) {
        this.x = FPMath.mul(this.x, scale);
        this.y = FPMath.mul(this.y, scale);
        this.z = FPMath.mul(this.z, scale);
    }

    public void invscale(int scale) {
        this.x = FPMath.div(this.x, scale);
        this.y = FPMath.div(this.y, scale);
        this.z = FPMath.div(this.z, scale);
    }

    public void store(IntBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
    }

    public String toString() {
        return "[" + FPMath.floatValue(this.x) + ", " + FPMath.floatValue(this.y) + ", " + FPMath.floatValue(this.z) + "]";
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }
}

