/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.resources.ResourceArray;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.SerializedSprite;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Stack;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sprite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SpriteImage missingImage;
    int index;
    private final SpriteEngine engine;
    private SpriteAllocator allocator;
    private Serializable owner;
    private boolean allocated;
    private Animation animation;
    private ResourceArray frameList;
    private int frame;
    private int loop;
    private int tick;
    private int sequence;
    private int event;
    private boolean paused;
    private float childXOffset;
    private float childYOffset;
    private SpriteImage image;
    private Style style;
    private int layer;
    private int subLayer;
    private float x;
    private float y;
    private float ox;
    private float oy;
    private float ySortOffset;
    private boolean flash;
    private final ReadableColor[] color = new ReadableColor[]{Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    private static final int NO_SCALE;
    private int xscale = NO_SCALE;
    private int yscale = NO_SCALE;
    private int alpha = 255;
    private int angle = 0;
    private boolean visible = true;
    private boolean active = true;
    private boolean mirrored;
    private boolean flipped;
    private boolean doChildOffset;
    private Stack<StackEntry> stack;

    static {
        NO_SCALE = FPMath.fpValue(1);
    }

    Sprite(SpriteEngine engine) {
        this.engine = engine;
    }

    public SpriteEngine getEngine() {
        return this.engine;
    }

    public void setAllocator(SpriteAllocator allocator) {
        this.allocator = allocator;
    }

    public SpriteAllocator getAllocator() {
        return this.allocator;
    }

    void copy(Sprite src) {
        this.image = src.image;
        this.style = src.style;
        this.layer = src.layer;
        this.subLayer = src.subLayer;
        this.x = src.x;
        this.y = src.y;
        this.ox = src.ox;
        this.oy = src.oy;
        this.ySortOffset = src.ySortOffset;
        this.flash = src.flash;
        int i = 0;
        while (i < 4) {
            this.color[i] = src.color[i];
            ++i;
        }
        this.xscale = src.xscale;
        this.yscale = src.yscale;
        this.alpha = src.alpha;
        this.angle = src.angle;
        this.visible = src.visible;
        this.active = src.active;
        this.mirrored = src.mirrored;
        this.flipped = src.flipped;
        this.doChildOffset = src.doChildOffset;
    }

    public void init(Serializable newOwner) {
        if (this.allocated) {
            throw new IllegalStateException(this + "Already allocated: " + newOwner + " can't have it!");
        }
        this.allocated = true;
        this.reset();
        this.owner = newOwner;
        this.active = true;
        this.visible = true;
        this.image = null;
        this.flash = false;
        this.ox = 0.0f;
        this.oy = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.color[0] = ReadableColor.WHITE;
        this.color[1] = ReadableColor.WHITE;
        this.color[2] = ReadableColor.WHITE;
        this.color[3] = ReadableColor.WHITE;
        this.layer = 0;
        this.subLayer = 0;
        this.xscale = NO_SCALE;
        this.yscale = NO_SCALE;
        this.alpha = 255;
        this.angle = 0;
        this.mirrored = false;
        this.flipped = false;
        this.doChildOffset = false;
        this.style = null;
    }

    public Serializable getOwner() {
        return this.owner;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public Vector2f getLocation(Vector2f ret) {
        if (ret == null) {
            ret = new Vector2f(this.x, this.y);
        } else {
            ret.set(this.x, this.y);
        }
        return ret;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(ReadableVector2f newLocation) {
        this.x = newLocation.getX();
        this.y = newLocation.getY();
    }

    public Vector2f getOffset(Vector2f ret) {
        if (ret == null) {
            ret = new Vector2f(this.ox, this.oy);
        } else {
            ret.set(this.ox, this.oy);
        }
        return ret;
    }

    public void setOffset(float ox, float oy) {
        this.ox = ox;
        this.oy = oy;
    }

    public void setOffset(ReadableVector2f location) {
        this.ox = location.getX();
        this.oy = location.getY();
    }

    public void tick() {
        if (!this.active || this.animation == null || this.isPaused()) {
            return;
        }
        this.animation.animate(this);
    }

    public void setFlash(boolean flash) {
        this.flash = flash;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getXScale() {
        return this.xscale;
    }

    public int getYScale() {
        return this.yscale;
    }

    public void setScale(int scale) {
        this.xscale = scale;
        this.yscale = scale;
    }

    public void setScale(int xscale, int yscale) {
        this.xscale = xscale;
        this.yscale = yscale;
    }

    public void adjustScale(int xscale, int yscale) {
        this.xscale += xscale;
        this.yscale += yscale;
    }

    public void adjustAlpha(int delta) {
        this.alpha = Math.max(0, Math.min(255, this.alpha + delta));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setColor(int index, ReadableColor color) {
        this.color[index] = color;
    }

    public void setColors(ReadableColor src) {
        this.color[0] = src;
        this.color[1] = src;
        this.color[2] = src;
        this.color[3] = src;
    }

    public void setAngle(int angle) {
        this.angle = angle % 65535;
    }

    public int getAngle() {
        return this.angle;
    }

    public void adjustAngle(int delta) {
        this.angle = (this.angle + delta) % 65535;
    }

    public ReadableColor getColor(int index) {
        return this.color[index];
    }

    public void setImage(SpriteImage image) {
        this.image = image;
        if (image == null) {
            return;
        }
        assert (image.isCreated()) : "Image " + image + " not created!";
        assert (image.getStyle() != null) : "Image " + image + " has no style!";
    }

    public void deactivate() {
        this.setActive(false);
    }

    public SpriteImage getImage() {
        return this.image;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style != null ? this.style : (this.getImage() != null ? this.getImage().getStyle() : null);
    }

    public void moveLocation(int dx, int dy) {
        this.x += (float)dx;
        this.y += (float)dy;
    }

    public void moveOffset(int dx, int dy) {
        this.ox += (float)dx;
        this.oy += (float)dy;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void deallocate() {
        if (!this.allocated) {
            assert (false);
            return;
        }
        this.setStyle(null);
        this.allocated = false;
        this.engine.deallocate(this);
        this.owner = null;
    }

    void forceDeallocate() {
        assert (this.allocated);
        this.allocated = false;
        this.visible = false;
    }

    public String toString() {
        return "Sprite[idx=" + this.index + ", owner=" + this.owner + ", image=" + this.image + ", active=" + this.active + ", visible=" + this.visible + ", position=" + this.x + "," + this.y + ", " + this.getAnimation() + ", " + this.getStyle() + "]";
    }

    public boolean isFlashing() {
        return this.flash;
    }

    public void setAppearance(Appearance appearance) {
        if (appearance == null) {
            this.image = null;
            this.setAnimation(null);
            this.rewind();
        } else {
            appearance.toSprite(this);
        }
    }

    public boolean isAllocated() {
        return this.allocated;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public boolean isDoChildOffset() {
        return this.doChildOffset;
    }

    public void setDoChildOffset(boolean doChildOffset) {
        this.doChildOffset = doChildOffset;
    }

    public void rotateToTarget(float dirX, float dirY) {
        this.setAngle(FPMath.fpYaklyDegrees(Util.angleFromDirection(dirX, dirY)));
    }

    private Object writeReplace() throws ObjectStreamException {
        SerializedSprite ss = new SerializedSprite();
        ss.fromSprite(this);
        return ss;
    }

    public static void setMissingImage(SpriteImage missingImage) {
        Sprite.missingImage = missingImage;
    }

    public static SpriteImage getMissingImage() {
        return missingImage;
    }

    float getOffsetY() {
        return this.oy;
    }

    public void setYSortOffset(float sortOffset) {
        this.ySortOffset = sortOffset;
    }

    public float getYSortOffset() {
        return this.ySortOffset;
    }

    public int getSubLayer() {
        return this.subLayer;
    }

    public void setSubLayer(int newSubLayer) {
        this.subLayer = newSubLayer;
    }

    public void pushSequence() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        if (this.stack.size() > 10) {
            System.err.println("Stack overflow " + this + "/" + this.getAnimation());
            return;
        }
        this.stack.push(new StackEntry(this.getAnimation(), this.getSequence() + 1));
    }

    public void popSequence() {
        if (this.stack == null) {
            return;
        }
        if (this.stack.size() == 0) {
            System.err.println("Stack underflow " + this + "/" + this.getAnimation());
            return;
        }
        StackEntry se = this.stack.pop();
        this.setAnimationNoRewind(se.animation);
        this.setSequence(se.sequence);
    }

    Stack<StackEntry> getStack() {
        return this.stack;
    }

    void setStack(Stack<StackEntry> stack) {
        this.stack = stack;
    }

    public void reset() {
        this.animation = null;
        this.frameList = null;
        this.sequence = 0;
        this.frame = 0;
        this.tick = 0;
        this.event = 0;
        this.paused = false;
        this.childXOffset = 0.0f;
        this.childYOffset = 0.0f;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (animation != null) assert (animation.isCreated());
        this.animation = animation;
        this.rewind();
    }

    void setAnimationNoRewind(Animation animation) {
        this.animation = animation;
        this.tick = 0;
    }

    public void rewind() {
        this.sequence = 0;
        this.tick = 0;
        this.tick();
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getTick() {
        return this.tick;
    }

    public void eventReceived(int event) {
    }

    public void setSequence(int newSeq) {
        this.sequence = newSeq;
    }

    public void setTick(int newTick) {
        this.tick = newTick;
    }

    public int getEvent() {
        return this.event;
    }

    public void setEvent(int event) {
        this.event = event;
    }

    public final boolean isPaused() {
        return this.paused;
    }

    public final void setPaused(boolean paused) {
        this.paused = paused;
    }

    public final void addLoop(int d) {
        this.loop += d;
    }

    public final int getLoop() {
        return this.loop;
    }

    public final void setLoop(int i) {
        this.loop = i;
    }

    public float getChildXOffset() {
        return this.childXOffset;
    }

    public void setChildXOffset(float childXOffset) {
        this.childXOffset = childXOffset;
    }

    public float getChildYOffset() {
        return this.childYOffset;
    }

    public void setChildYOffset(float childYOffset) {
        this.childYOffset = childYOffset;
    }

    public void setFrameList(ResourceArray frameList) {
        this.frameList = frameList;
        if (frameList != null) {
            this.updateFrame();
        }
    }

    public ResourceArray getFrameList() {
        return this.frameList;
    }

    public int getFrame() {
        return this.frame;
    }

    public boolean setFrame(int frame) {
        this.frame = frame;
        if (this.frameList != null) {
            return this.updateFrame();
        }
        return false;
    }

    private boolean updateFrame() {
        if (this.frame < 0 || this.frame >= this.frameList.getNumResources()) {
            return false;
        }
        Appearance newAppearance = (Appearance)this.frameList.getResource(this.frame);
        if (this.animation != null && newAppearance != this.animation || this.animation == null) {
            return newAppearance.toSprite(this);
        }
        return false;
    }

    static class StackEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Animation animation;
        final int sequence;

        StackEntry(Animation animation, int sequence) {
            this.animation = animation;
            this.sequence = sequence;
        }
    }
}

