/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Stack;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SerializedSprite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SpriteAllocator spriteAllocator;
    private Animation animation;
    private SpriteImage image;
    private int tick;
    private int sequence;
    private int loop;
    private int layer;
    private int subLayer;
    private Vector2f location = new Vector2f();
    private Vector2f offset = new Vector2f();
    private boolean flash;
    private final ReadableColor[] color = new ReadableColor[4];
    private int xscale;
    private int yscale;
    private int alpha;
    private int angle;
    private boolean visible;
    private boolean active;
    private int event;
    private boolean paused;
    private boolean mirrored;
    private boolean flipped;
    private float childXOffset;
    private float childYOffset;
    private boolean doChildOffset;
    private float ySortOffset;
    private Stack<Sprite.StackEntry> stack;
    private Serializable owner;

    public void fromSprite(Sprite source) {
        this.spriteAllocator = source.getAllocator();
        this.animation = source.getAnimation();
        this.image = source.getImage();
        this.loop = source.getLoop();
        this.tick = source.getTick();
        this.sequence = source.getSequence();
        this.layer = source.getLayer();
        this.subLayer = source.getSubLayer();
        source.getLocation(this.location);
        source.getOffset(this.offset);
        this.flash = source.isFlashing();
        this.color[0] = source.getColor(0);
        this.color[1] = source.getColor(1);
        this.color[2] = source.getColor(2);
        this.color[3] = source.getColor(3);
        this.xscale = source.getXScale();
        this.yscale = source.getYScale();
        this.alpha = source.getAlpha();
        this.angle = source.getAngle();
        this.visible = source.isVisible();
        this.active = source.isActive();
        this.event = source.getEvent();
        this.paused = source.isPaused();
        this.mirrored = source.isMirrored();
        this.flipped = source.isFlipped();
        this.childXOffset = source.getChildXOffset();
        this.childYOffset = source.getChildYOffset();
        this.doChildOffset = source.isDoChildOffset();
        this.stack = source.getStack();
        this.ySortOffset = source.getYSortOffset();
        this.owner = source.getOwner();
    }

    public void toSprite(Sprite dest) throws Exception {
        if (!dest.isAllocated()) {
            throw new Exception("Sprite is not allocated!");
        }
        dest.setAnimationNoRewind(this.animation);
        dest.setImage(this.image);
        dest.setLoop(this.loop);
        dest.setTick(this.tick);
        dest.setSequence(this.sequence);
        dest.setLayer(this.layer);
        dest.setSubLayer(this.subLayer);
        dest.setLocation(this.location.getX(), this.location.getY());
        dest.setOffset((ReadableVector2f)this.offset);
        dest.setFlash(this.flash);
        dest.setColor(0, this.color[0]);
        dest.setColor(1, this.color[1]);
        dest.setColor(2, this.color[2]);
        dest.setColor(3, this.color[3]);
        dest.setScale(this.xscale, this.yscale);
        dest.setAlpha(this.alpha);
        dest.setAngle(this.angle);
        dest.setVisible(this.visible);
        dest.setActive(this.active);
        dest.setEvent(this.event);
        dest.setPaused(this.paused);
        dest.setMirrored(this.mirrored);
        dest.setFlipped(this.flipped);
        dest.setChildXOffset(this.childXOffset);
        dest.setChildYOffset(this.childYOffset);
        dest.setDoChildOffset(this.doChildOffset);
        dest.setStack(this.stack);
        dest.setYSortOffset(this.ySortOffset);
    }

    private Object readResolve() throws ObjectStreamException {
        Sprite sprite = this.spriteAllocator.allocateSprite(this.owner);
        sprite.setAllocator(this.spriteAllocator);
        try {
            this.toSprite(sprite);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new InvalidObjectException("Failed to deserialize sprite due to " + e);
        }
        return sprite;
    }
}

