/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.sprites.AbstractStyle;
import com.shavenpuppy.jglib.sprites.GeometryData;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.FloatList;
import com.shavenpuppy.jglib.util.ShortList;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.vector.ReadableVector2f;

public abstract class GeometryStyle
extends AbstractStyle
implements SimpleRenderer {
    private final ArrayList<GeometryRun> geometry = new ArrayList(1);
    private transient GeometryData data;
    private transient FloatList vertices;
    private transient short numVertices;
    private transient ShortList indices;
    private transient float u;
    private transient float v;
    private transient int c;
    private transient boolean hasColor;
    private transient boolean hasTexture;
    private transient MeshGeometry previous;

    public final boolean getRenderSprite() {
        return false;
    }

    public final int getStyleID() {
        return this.hashCode();
    }

    public final GeometryData build() {
        if (this.data == null) {
            this.data = new GeometryData(new FloatList(true, 128), new ShortList(true, 128));
            this.vertices = this.data.getVertexData();
            this.indices = this.data.getIndexData();
        }
        this.data.clear();
        this.numVertices = 0;
        this.render();
        return this.data;
    }

    public final void setupState() {
    }

    public final void resetState() {
    }

    protected abstract void render();

    public void glRender(GLRenderable renderable) {
        this.geometry.add(new RenderableGeometry(renderable));
        this.previous = null;
    }

    private static boolean isContinuable(int type) {
        return type == 4 || type == 7 || type == 0 || type == 1;
    }

    public void glRender(int primitiveType, short[] indices) {
        if (indices.length == 0) {
            return;
        }
        if (this.previous != null && this.previous.primitiveType == primitiveType && GeometryStyle.isContinuable(primitiveType)) {
            MeshGeometry gr = this.previous;
            gr.numIndices += indices.length;
        } else {
            MeshGeometry gr = new MeshGeometry(primitiveType, this.indices.size() * 2, indices.length);
            this.geometry.add(gr);
            this.previous = gr;
        }
        this.indices.addAll(indices);
    }

    public short glVertex2f(float x, float y) {
        this.vertices.add(x);
        this.vertices.add(y);
        this.vertices.add(this.u);
        this.vertices.add(this.v);
        this.vertices.add(Float.intBitsToFloat(this.c));
        short s = this.numVertices;
        this.numVertices = (short)(s + 1);
        return s;
    }

    public short getVertexOffset() {
        return this.numVertices;
    }

    public short glVertex(ReadablePoint vertex) {
        return this.glVertex2f(vertex.getX(), vertex.getY());
    }

    public short glVertex(ReadableVector2f vertex) {
        return this.glVertex2f(vertex.getX(), vertex.getY());
    }

    public void glTexCoord2f(float u, float v) {
        this.u = u;
        this.v = v;
        this.hasTexture = true;
    }

    public void glColori(int color) {
        this.c = color;
        this.hasColor = true;
    }

    public void glColor4ub(byte r, byte g, byte b, byte a) {
        this.c = a << 24 & 0xFF000000 | b << 16 & 0xFF0000 | g << 8 & 0xFF00 | r & 0xFF;
        this.hasColor = true;
    }

    public void glColor3ub(byte r, byte g, byte b) {
        this.glColor4ub(r, g, b, (byte)-1);
    }

    public void glColor4f(float r, float g, float b, float a) {
        this.glColor4ub((byte)(r * 255.0f), (byte)(g * 255.0f), (byte)(b * 255.0f), (byte)(a * 255.0f));
    }

    public void glColor3f(float r, float g, float b) {
        this.glColor4f(r, g, b, 1.0f);
    }

    public void glColor(ReadableColor color) {
        this.glColor4ub(color.getRedByte(), color.getGreenByte(), color.getBlueByte(), color.getAlphaByte());
    }

    public final void render(int vertexOffset, int indexOffset) {
        GL11.glEnableClientState((int)32884);
        if (this.hasColor) {
            GL11.glEnableClientState((int)32886);
        } else {
            GL11.glDisableClientState((int)32886);
        }
        if (this.hasTexture) {
            GL11.glEnableClientState((int)32888);
        } else {
            GL11.glDisableClientState((int)32888);
        }
        int n = this.geometry.size();
        int i = 0;
        while (i < n) {
            GeometryRun run = this.geometry.get(i);
            run.render(vertexOffset, indexOffset * 2);
            ++i;
        }
        this.geometry.clear();
        this.previous = null;
        if (this.hasColor) {
            this.hasColor = false;
        }
        if (this.hasTexture) {
            this.hasTexture = false;
        }
        GL11.glEnableClientState((int)32886);
        GL11.glEnableClientState((int)32888);
    }

    private static interface GeometryRun {
        public void render(int var1, int var2);
    }

    private class MeshGeometry
    implements GeometryRun {
        int primitiveType;
        int numIndices;
        int offset;

        public MeshGeometry(int primitiveType, int offset, int numIndices) {
            this.primitiveType = primitiveType;
            this.numIndices = numIndices;
            this.offset = offset;
        }

        public void render(int vertexOffset, int indexOffset) {
            GL12.glDrawRangeElements((int)this.primitiveType, (int)vertexOffset, (int)(vertexOffset + GeometryStyle.this.numVertices), (int)this.numIndices, (int)5123, (long)(this.offset + indexOffset));
        }
    }

    private static class RenderableGeometry
    implements GeometryRun {
        GLRenderable renderable;

        public RenderableGeometry(GLRenderable renderable) {
            this.renderable = renderable;
        }

        public void render(int vertexOffset, int indexOffset) {
            this.renderable.render();
        }
    }
}

