/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import java.io.IOException;
import org.w3c.dom.Element;

public class FrameCommand
extends Command {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private int duration;
    private float childXOffset;
    private float childYOffset;
    private String appearanceName;
    private int idx;
    private transient Appearance spriteAppearance;

    public void archive() {
        this.appearanceName = null;
    }

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick() + 1;
        if (currentTick == 1) {
            boolean twiddle;
            target.setChildXOffset(this.childXOffset);
            target.setChildYOffset(this.childYOffset);
            if (this.appearanceName == null) {
                twiddle = target.setFrame(this.idx);
            } else {
                if (this.spriteAppearance == null) {
                    return false;
                }
                twiddle = this.spriteAppearance.toSprite(target);
            }
            if (twiddle) {
                return false;
            }
        }
        if (currentTick > this.duration) {
            target.setSequence(currentSequence + 1);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        if (element.hasAttribute("idx")) {
            this.idx = Integer.parseInt(element.getAttribute("idx"));
        } else {
            this.appearanceName = element.getAttribute("i");
        }
        this.duration = Integer.parseInt(element.getAttribute("d"));
        this.childXOffset = element.hasAttribute("childXOffset") ? Float.parseFloat(element.getAttribute("childXOffset")) : 0.0f;
        this.childYOffset = element.hasAttribute("childYOffset") ? Float.parseFloat(element.getAttribute("childYOffset")) : 0.0f;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.appearanceName != null) {
            writer.writeAttribute("i", this.appearanceName, true);
        } else {
            writer.writeAttribute("idx", this.idx, true);
        }
        writer.writeAttribute("d", this.duration, true);
        writer.writeAttribute("childXOffset", this.childXOffset, false);
        writer.writeAttribute("childYOffset", this.childYOffset, false);
    }

    protected void doCreate() {
        if (this.appearanceName != null) {
            this.spriteAppearance = (Appearance)Resources.get(this.appearanceName);
        }
    }

    protected void doDestroy() {
        this.spriteAppearance = null;
    }
}

