/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLVertexBufferObject;
import com.shavenpuppy.jglib.sprites.AlphaOp;
import com.shavenpuppy.jglib.sprites.FlashStyle;
import com.shavenpuppy.jglib.sprites.GeometryData;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.SpriteRenderer;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.FloatList;
import com.shavenpuppy.jglib.util.ShortList;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.vector.Vector2f;

class DefaultSpriteRenderer
extends Resource
implements SpriteRenderer {
    private static final long serialVersionUID = 1L;
    private static final float PREMULT_ALPHA = 0.003921569f;
    private static final Vector2f offset = new Vector2f();
    private static RingBuffer ringBuffer;
    private final RadixSort sort = new RadixSort();
    private static final int NO_SCALE;
    private static final boolean DEBUG = true;
    private float alpha;
    private final boolean uniqueSprites;
    private int[] sort_y;
    private int[] sort_x;
    private int[] sort_layer;
    private int[] sort_sublayer;
    private int[] sort_style;
    private int[] sort_texture0;
    private final boolean sortY;
    private Sprite[] sprite;
    private Style[] style;
    private int numSprites;
    private int sortLayer;
    static final int VERTEX_SIZE = 20;
    static final int TEXTURE0_COORD_OFFSET = 8;
    static final int COLOR_OFFSET = 16;

    static {
        NO_SCALE = FPMath.ONE;
    }

    DefaultSpriteRenderer(boolean sortY, int sortLayer, boolean uniqueSprites) {
        this.sortY = sortY;
        this.sortLayer = sortLayer;
        this.uniqueSprites = uniqueSprites;
        this.sprite = new Sprite[1];
        if (uniqueSprites) {
            int i = 0;
            while (i < this.sprite.length) {
                this.sprite[i] = new Sprite(null);
                ++i;
            }
        }
        this.style = new Style[1];
        this.sort_layer = new int[1];
        this.sort_sublayer = new int[1];
        this.sort_texture0 = new int[1];
        this.sort_style = new int[1];
        if (sortY) {
            this.sort_y = new int[1];
            this.sort_x = new int[1];
        } else {
            this.sort_y = null;
            this.sort_x = null;
        }
        this.sort.resetIndices();
    }

    protected void doCreate() {
        if (ringBuffer == null) {
            ringBuffer = new RingBuffer();
            ringBuffer.create();
        }
        if (FlashStyle.instance == null) {
            FlashStyle.instance = new FlashStyle("flash.style");
            FlashStyle.instance.create();
        }
    }

    protected void doDestroy() {
    }

    public void render(Sprite s) {
        if (!s.isVisible()) {
            return;
        }
        SpriteImage image = s.getImage();
        Style spriteStyle = s.getStyle();
        if (image == null && spriteStyle == null) {
            return;
        }
        if (s.isFlashing() && GLContext.getCapabilities().GL_EXT_secondary_color) {
            this.addSprite(FlashStyle.instance, s);
        } else {
            this.addSprite(spriteStyle, s);
        }
    }

    private void addSprite(Style spriteStyle, Sprite s) {
        if (this.numSprites == this.sprite.length) {
            if (this.sortY) {
                int[] old_sort_y = this.sort_y;
                this.sort_y = new int[this.numSprites * 2];
                System.arraycopy(old_sort_y, 0, this.sort_y, 0, this.numSprites);
                old_sort_y = null;
                int[] old_sort_x = this.sort_x;
                this.sort_x = new int[this.numSprites * 2];
                System.arraycopy(old_sort_x, 0, this.sort_x, 0, this.numSprites);
                old_sort_x = null;
            }
            int[] old_sort_layer = this.sort_layer;
            this.sort_layer = new int[this.numSprites * 2];
            System.arraycopy(old_sort_layer, 0, this.sort_layer, 0, this.numSprites);
            old_sort_layer = null;
            int[] old_sort_sublayer = this.sort_sublayer;
            this.sort_sublayer = new int[this.numSprites * 2];
            System.arraycopy(old_sort_sublayer, 0, this.sort_sublayer, 0, this.numSprites);
            old_sort_sublayer = null;
            int[] old_sort_style = this.sort_style;
            this.sort_style = new int[this.numSprites * 2];
            System.arraycopy(old_sort_style, 0, this.sort_style, 0, this.numSprites);
            old_sort_style = null;
            int[] old_sort_texture0 = this.sort_texture0;
            this.sort_texture0 = new int[this.numSprites * 2];
            System.arraycopy(old_sort_texture0, 0, this.sort_texture0, 0, this.numSprites);
            old_sort_texture0 = null;
            Sprite[] old_sprite = this.sprite;
            this.sprite = new Sprite[this.numSprites * 2];
            System.arraycopy(old_sprite, 0, this.sprite, 0, this.numSprites);
            old_sprite = null;
            Style[] old_style = this.style;
            this.style = new Style[this.numSprites * 2];
            System.arraycopy(old_style, 0, this.style, 0, this.numSprites);
            old_style = null;
        }
        this.style[this.numSprites] = spriteStyle;
        if (this.uniqueSprites) {
            Sprite copy = this.sprite[this.numSprites];
            if (copy == null) {
                copy = this.sprite[this.numSprites] = new Sprite(null);
            }
            copy.copy(s);
        } else {
            this.sprite[this.numSprites] = s;
        }
        ++this.numSprites;
    }

    public void postRender() {
        if (this.numSprites == 0) {
            return;
        }
        this.sort();
        ringBuffer.begin();
        this.build();
        ringBuffer.finish();
    }

    private void build() {
        int[] index = this.sort.getIndices();
        int i = 0;
        while (i < this.numSprites) {
            int idx = index[i];
            Sprite s = this.sprite[idx];
            if (s.isVisible()) {
                Style newStyle = this.style[idx];
                if (newStyle.getRenderSprite()) {
                    ringBuffer.add(s, newStyle, this.alpha);
                } else {
                    ringBuffer.add(newStyle);
                }
            }
            ++i;
        }
    }

    public void preRender() {
        this.numSprites = 0;
    }

    private void sort() {
        int n = this.numSprites;
        if (this.sortY) {
            int i = 0;
            while (i < n) {
                Sprite s = this.sprite[i];
                if (s.isVisible()) {
                    this.sort_x[i] = (int)s.getX();
                    this.sort_layer[i] = s.getLayer();
                    this.sort_sublayer[i] = s.getSubLayer();
                    this.sort_style[i] = this.style[i].getStyleID();
                    if (s.getStyle().getRenderSprite()) {
                        SpriteImage si = s.getImage();
                        GLBaseTexture tex = si.getTexture();
                        int n2 = this.sort_texture0[i] = tex == null ? 0 : tex.getID();
                        this.sort_y[i] = s.getLayer() >= this.sortLayer ? 0 : (int)(-(s.getY() + s.getYSortOffset()));
                    } else {
                        this.sort_texture0[i] = 0;
                        this.sort_y[i] = 0;
                    }
                }
                ++i;
            }
            this.sort.resetIndices().sort(this.sort_style, n).sort(this.sort_texture0, n).sort(this.sort_x, n).sort(this.sort_sublayer, n).sort(this.sort_y, n).sort(this.sort_layer, n);
        } else {
            int i = 0;
            while (i < n) {
                Sprite s = this.sprite[i];
                if (s.isVisible()) {
                    SpriteImage si;
                    GLBaseTexture tex;
                    this.sort_layer[i] = s.getLayer();
                    this.sort_sublayer[i] = s.getSubLayer();
                    this.sort_style[i] = this.style[i].getStyleID();
                    this.sort_texture0[i] = s.getStyle().getRenderSprite() ? ((tex = (si = s.getImage()).getTexture()) == null ? 0 : tex.getID()) : 0;
                }
                ++i;
            }
            this.sort.resetIndices().sort(this.sort_style, n).sort(this.sort_texture0, n).sort(this.sort_sublayer, n).sort(this.sort_layer, n);
        }
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private static class RingBuffer {
        private static final int DEFAULT_STATE_RUNS = 1024;
        int bufferSize;
        int bufferSizeInVertices;
        int indexBufferSize;
        int numBuffers;
        GLVertexBufferObject[] vbo;
        GLVertexBufferObject[] ibo;
        FloatBuffer[] vertices;
        ByteBuffer[] verticesBytes;
        ShortBuffer[] indices;
        ByteBuffer[] indicesBytes;
        int sequence = -1;
        int mark = -1;
        FloatBuffer currentVertices;
        ShortBuffer currentIndices;
        StateRun[] stateRun;
        GLBaseTexture lastRenderedTexture0;
        GLBaseTexture currentTexture0;
        Style lastRenderedStyle;
        Style currentStyle;
        int vertexCursor;
        int indexCursor;
        int numRuns;
        StateRun currentRun;

        RingBuffer() {
        }

        void create() {
            this.bufferSize = 262144;
            this.bufferSizeInVertices = this.bufferSize / 20;
            this.numBuffers = 8;
            this.indexBufferSize = this.bufferSizeInVertices * 3;
            this.vertices = new FloatBuffer[this.numBuffers];
            this.verticesBytes = new ByteBuffer[this.numBuffers];
            this.indices = new ShortBuffer[this.numBuffers];
            this.indicesBytes = new ByteBuffer[this.numBuffers];
            this.vbo = new GLVertexBufferObject[this.numBuffers];
            this.ibo = new GLVertexBufferObject[this.numBuffers];
            int i = 0;
            while (i < this.numBuffers) {
                this.vbo[i] = new GLVertexBufferObject(this.bufferSize, 34962, 35040);
                this.vbo[i].create();
                this.ibo[i] = new GLVertexBufferObject(this.indexBufferSize * 2, 34963, 35040);
                this.ibo[i].create();
                ++i;
            }
            this.stateRun = new StateRun[1024];
            i = 0;
            while (i < this.stateRun.length) {
                this.stateRun[i] = new StateRun();
                ++i;
            }
        }

        private void next() {
            ++this.sequence;
            if (this.sequence == this.numBuffers) {
                this.sequence = 0;
            }
            if (this.sequence == this.mark) {
                System.out.println("Buffer overrun");
            }
            this.vbo[this.sequence].render();
            this.ibo[this.sequence].render();
            ByteBuffer buf = this.vbo[this.sequence].map();
            if (this.vertices[this.sequence] == null || this.verticesBytes[this.sequence] != buf) {
                this.verticesBytes[this.sequence] = buf;
                this.vertices[this.sequence] = buf.asFloatBuffer();
            }
            ByteBuffer ibuf = this.ibo[this.sequence].map();
            if (this.indices[this.sequence] == null || this.indicesBytes[this.sequence] != ibuf) {
                this.indicesBytes[this.sequence] = ibuf;
                this.indices[this.sequence] = ibuf.asShortBuffer();
            }
            this.currentVertices = this.vertices[this.sequence];
            this.currentVertices.clear();
            this.currentIndices = this.indices[this.sequence];
            this.currentIndices.clear();
            GL11.glVertexPointer((int)2, (int)5126, (int)20, (long)0L);
            GL11.glTexCoordPointer((int)2, (int)5126, (int)20, (long)8L);
            GL11.glColorPointer((int)4, (int)5121, (int)20, (long)16L);
            this.vertexCursor = 0;
            this.indexCursor = 0;
            this.numRuns = 0;
            this.currentRun = null;
        }

        void begin() {
            this.currentStyle = null;
            this.currentTexture0 = null;
            this.next();
            this.mark = this.sequence;
            GL11.glEnableClientState((int)32884);
        }

        void finish() {
            this.render();
            ARBBufferObject.glBindBufferARB((int)34962, (int)0);
            ARBBufferObject.glBindBufferARB((int)34963, (int)0);
        }

        void growStateRuns() {
            StateRun[] newStateRun = new StateRun[(int)((float)this.stateRun.length * 1.5f)];
            System.arraycopy(this.stateRun, 0, newStateRun, 0, this.stateRun.length);
            int i = this.numRuns;
            while (i < newStateRun.length) {
                newStateRun[i] = new StateRun();
                ++i;
            }
            this.stateRun = newStateRun;
        }

        void add(Sprite s, Style newStyle, float engineAlpha) {
            float scaledy01;
            float scaledy11;
            float scaledy10;
            float scaledy00;
            float scaledx01;
            float scaledx11;
            float scaledx10;
            float scaledx00;
            SpriteImage image;
            GLBaseTexture newTexture0;
            if (this.vertexCursor + 4 > this.bufferSizeInVertices || this.indexCursor + 6 > this.indexBufferSize) {
                this.render();
                this.next();
            }
            GLBaseTexture gLBaseTexture = newTexture0 = (image = s.getImage()) != null ? image.getTexture() : null;
            if (this.currentRun == null || newStyle != this.currentStyle && (this.currentStyle == null || newStyle.getStyleID() != this.currentStyle.getStyleID()) || newTexture0 != this.currentTexture0) {
                this.currentRun = this.stateRun[this.numRuns];
                this.currentRun.start = this.vertexCursor;
                this.currentRun.length = 0;
                this.currentRun.style = newStyle;
                this.currentRun.texture0 = newTexture0;
                this.currentRun.indices = this.currentIndices;
                this.currentRun.startIndex = this.indexCursor;
                this.currentRun.endIndex = this.indexCursor;
                ++this.numRuns;
                if (this.numRuns == this.stateRun.length) {
                    this.growStateRuns();
                }
                this.currentStyle = newStyle;
                this.currentTexture0 = newTexture0;
            }
            float w = image.getWidth();
            float h = image.getHeight();
            float tx0 = image.getTx0();
            float tx1 = image.getTx1();
            float ty0 = image.getTy0();
            float ty1 = image.getTy1();
            int xscale = s.getXScale();
            int yscale = s.getYScale();
            s.getOffset(offset);
            float x = s.getX() + offset.getX();
            float y = s.getY() + offset.getY();
            int alpha = (int)(engineAlpha * (float)s.getAlpha());
            float angle = FPMath.floatValue(s.getAngle()) * ((float)Math.PI * 2);
            float scaledx0 = -image.getHotspotX();
            float scaledy0 = -image.getHotspotY();
            float scaledx1 = scaledx0 + w;
            float scaledy1 = scaledy0 + h;
            if (xscale != NO_SCALE || yscale != NO_SCALE) {
                float fxScale = FPMath.floatValue(xscale);
                float fyScale = FPMath.floatValue(yscale);
                scaledx0 *= fxScale;
                scaledx1 *= fxScale;
                scaledy0 *= fyScale;
                scaledy1 *= fyScale;
            }
            if (angle != 0.0f) {
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                scaledx00 = cos * scaledx0 - sin * scaledy0;
                scaledx10 = cos * scaledx1 - sin * scaledy0;
                scaledx11 = cos * scaledx1 - sin * scaledy1;
                scaledx01 = cos * scaledx0 - sin * scaledy1;
                scaledy00 = sin * scaledx0 + cos * scaledy0;
                scaledy10 = sin * scaledx1 + cos * scaledy0;
                scaledy11 = sin * scaledx1 + cos * scaledy1;
                scaledy01 = sin * scaledx0 + cos * scaledy1;
            } else {
                scaledx00 = scaledx0;
                scaledx10 = scaledx1;
                scaledx11 = scaledx1;
                scaledx01 = scaledx0;
                scaledy00 = scaledy0;
                scaledy10 = scaledy0;
                scaledy11 = scaledy1;
                scaledy01 = scaledy1;
            }
            float x00 = scaledx00 + x;
            float x01 = scaledx01 + x;
            float x11 = scaledx11 + x;
            float x10 = scaledx10 + x;
            float y00 = scaledy00 + y;
            float y01 = scaledy01 + y;
            float y11 = scaledy11 + y;
            float y10 = scaledy10 + y;
            AlphaOp alphaOp = newStyle.getAlphaOp();
            FloatBuffer floats = this.currentVertices;
            float mtx = s.isMirrored() ? tx1 : tx0;
            float fty = s.isFlipped() ? ty0 : ty1;
            float mtx1 = s.isMirrored() ? tx0 : tx1;
            float mty1 = s.isFlipped() ? ty1 : ty0;
            floats.put(x00);
            floats.put(y00);
            floats.put(mtx);
            floats.put(fty);
            ReadableColor color = s.getColor(0);
            alphaOp.op(color, alpha, floats);
            floats.put(x10);
            floats.put(y10);
            floats.put(mtx1);
            floats.put(fty);
            color = s.getColor(1);
            alphaOp.op(color, alpha, floats);
            floats.put(x11);
            floats.put(y11);
            floats.put(mtx1);
            floats.put(mty1);
            color = s.getColor(2);
            alphaOp.op(color, alpha, floats);
            floats.put(x01);
            floats.put(y01);
            floats.put(mtx);
            floats.put(mty1);
            color = s.getColor(3);
            alphaOp.op(color, alpha, floats);
            this.currentIndices.put((short)this.vertexCursor);
            this.currentIndices.put((short)(this.vertexCursor + 1));
            this.currentIndices.put((short)(this.vertexCursor + 2));
            this.currentIndices.put((short)this.vertexCursor);
            this.currentIndices.put((short)(this.vertexCursor + 2));
            this.currentIndices.put((short)(this.vertexCursor + 3));
            this.indexCursor += 6;
            this.vertexCursor += 4;
            this.currentRun.endIndex += 6;
            this.currentRun.length += 4;
        }

        void add(Style s) {
            GeometryData data = s.build();
            FloatList vertexData = data.getVertexData();
            ShortList indexData = data.getIndexData();
            int vertsToWrite = vertexData.size() / 5;
            if (this.vertexCursor + vertsToWrite > this.bufferSizeInVertices) {
                this.render();
                this.next();
            }
            this.currentRun = this.stateRun[this.numRuns];
            this.currentRun.start = this.vertexCursor;
            this.currentRun.length = vertsToWrite;
            this.currentRun.style = s;
            this.currentRun.texture0 = null;
            this.currentRun.startIndex = this.indexCursor;
            ++this.numRuns;
            if (this.numRuns == this.stateRun.length) {
                this.growStateRuns();
            }
            this.currentVertices.position(this.vertexCursor * 20 >> 2);
            this.currentVertices.put(vertexData.array(), 0, vertexData.size());
            this.currentIndices.position(this.indexCursor);
            short[] idx = indexData.array();
            int indicesToWrite = indexData.size();
            int i = 0;
            while (i < indicesToWrite) {
                int n = i++;
                idx[n] = (short)(idx[n] + this.vertexCursor);
            }
            this.currentIndices.put(idx, 0, indicesToWrite);
            this.vertexCursor += vertsToWrite;
            this.indexCursor += indicesToWrite;
            this.currentStyle = null;
            this.currentTexture0 = null;
        }

        void render() {
            this.vbo[this.sequence].unmap();
            this.ibo[this.sequence].unmap();
            this.lastRenderedStyle = null;
            this.lastRenderedTexture0 = null;
            int i = 0;
            while (i < this.numRuns) {
                this.stateRun[i].render();
                ++i;
            }
            if (this.lastRenderedStyle != null) {
                this.lastRenderedStyle.resetState();
            }
        }

        private class StateRun {
            GLBaseTexture texture0;
            Style style;
            int start;
            int length;
            ShortBuffer indices;
            int startIndex;
            int endIndex;

            private StateRun() {
            }

            void render() {
                if (this.style != RingBuffer.this.lastRenderedStyle) {
                    if (RingBuffer.this.lastRenderedStyle != null) {
                        RingBuffer.this.lastRenderedStyle.resetState();
                    }
                    if (this.style != null) {
                        this.style.setupState();
                    }
                    RingBuffer.this.lastRenderedStyle = this.style;
                }
                if (this.texture0 != RingBuffer.this.lastRenderedTexture0) {
                    if (this.texture0 != null) {
                        this.texture0.render();
                    }
                    RingBuffer.this.lastRenderedTexture0 = this.texture0;
                }
                if (this.length == 0) {
                    return;
                }
                if (this.style.getRenderSprite()) {
                    GL12.glDrawRangeElements((int)4, (int)this.start, (int)(this.start + this.length), (int)(this.endIndex - this.startIndex), (int)5123, (long)(this.startIndex * 2));
                } else {
                    this.style.render(this.start, this.startIndex);
                }
            }
        }
    }
}

