/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class ColorCommand
extends Command {
    private static final long serialVersionUID = 1L;
    private MappedColor color;
    private int duration;

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick() + 1;
        if (currentTick == 1) {
            target.setColors(this.color);
        }
        if (currentTick > this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.color = new MappedColor();
        this.color.fromString(XMLUtil.getString(element, "c"));
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("c", this.color.toString());
        writer.writeAttribute("d", this.duration, true);
    }
}

