/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.IResource;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConverter
implements Resource.Loader {
    private static final boolean DEBUG = false;
    private static int uniqueNameCounter;
    static final Class<?>[] namedSig;
    static final Class<?>[] unnamedSig;
    private Map<String, Class<? extends IResource>> typeMap = new HashMap<String, Class<? extends IResource>>();
    Stack<Map<String, Class<? extends IResource>>> stack = new Stack();
    private boolean overwrite;
    private final Set<String> included = new HashSet<String>();
    private ResourceLoadedListener loadedListener;
    private final Stack<String> resourcePath = new Stack();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    static {
        namedSig = new Class[]{String.class};
        unnamedSig = new Class[0];
    }

    public ResourceConverter() {
    }

    public ResourceConverter(ResourceLoadedListener loadedListener, ClassLoader classLoader) {
        this.loadedListener = loadedListener;
        this.classLoader = classLoader;
    }

    public ResourceConverter(String resourceName) throws Exception {
        this.include(resourceName);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.err.println("Usage: ResourceConverter <classpath-xml-resource> <destpath>");
                System.exit(-1);
            }
            new ResourceConverter(args[0]);
            Resources.save(new FileOutputStream(args[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetIncludes() {
        this.included.clear();
    }

    private void log(String msg) {
    }

    public void include(String resourceName) throws Exception {
        this.log("Including resources from:" + resourceName);
        try {
            this.resourcePath.push(resourceName);
            InputStream is = this.classLoader.getResourceAsStream(resourceName);
            if (is == null) {
                ClassLoader l = Thread.currentThread().getContextClassLoader();
                is = l.getResourceAsStream(resourceName);
            }
            if (is == null) {
                is = new BufferedInputStream(new FileInputStream(resourceName));
            }
            try {
                this.include(is);
            }
            catch (Exception e) {
                throw new Exception("Failed to include '" + resourceName + "'", e);
            }
        }
        finally {
            this.resourcePath.pop();
        }
    }

    public void load(String input) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(input.getBytes()));
        Element root = document.getDocumentElement();
        this.load(root);
    }

    @Override
    public void include(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        Element root = document.getDocumentElement();
        String name = XMLUtil.getString(root, "name", null);
        if (name != null) {
            if (this.included.contains(name)) {
                return;
            }
            this.included.add(name);
            this.resourcePath.push(name);
        }
        NodeList childNodeList = root.getChildNodes();
        int i = 0;
        while (i < childNodeList.getLength()) {
            Node node = childNodeList.item(i);
            if (node.getNodeType() == 1) {
                Element featureElement = (Element)node;
                this.load(featureElement);
            }
            ++i;
        }
        if (name != null) {
            this.resourcePath.pop();
        }
    }

    private void ifDef(Element element, boolean match) throws Exception {
        String key = element.getAttribute("key");
        String value = element.getAttribute("value");
        this.log("Checking condition: " + key + "=" + value + "...");
        if (System.getProperty(key, "<undefined>").equals(value) == match) {
            this.log("true");
            NodeList children = element.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    this.load((Element)child);
                }
                ++i;
            }
        } else {
            this.log("false");
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public IResource load(Element featureElement) throws Exception {
        if (featureElement.getNodeName().equals("include")) {
            String name = featureElement.getAttribute("resource");
            if (name == null) {
                throw new Exception("Missing 'resource' attribute in include tag");
            }
            this.log("Including " + name);
            this.include(name);
            return null;
        }
        if (featureElement.getNodeName().equals("map")) {
            String tag = featureElement.getAttribute("tag");
            if (tag == null || "".equals(tag)) {
                throw new Exception("Missing 'tag' attribute");
            }
            if (tag.equals("map")) {
                throw new Exception("Cannot reassign 'map' tag");
            }
            String className = featureElement.getAttribute("class");
            if (className == null || "".equals(className)) {
                throw new Exception("Missing 'class' attribute");
            }
            Class<?> clazz = Class.forName(className, true, this.getClassLoader());
            if (!Resource.class.isAssignableFrom(clazz)) {
                throw new Exception(clazz + " is not a Resource.");
            }
            Class<? extends IResource> oldClazz = this.typeMap.get(tag);
            this.typeMap.put(tag, clazz);
            Resources.registerTag(clazz, tag);
            if (oldClazz == null) {
                this.log("Mapping <" + tag + "> to " + className);
            } else if (oldClazz != clazz) {
                this.log("Re-mapping <" + tag + "> to " + className + " : old mapping was " + oldClazz.getName());
            }
            return null;
        }
        if (featureElement.getNodeName().equals("instance")) {
            String className = featureElement.getAttribute("class");
            if (className == null || "".equals(className)) {
                throw new Exception("Missing 'class' attribute");
            }
            Class<?> clazz = Class.forName(className, true, this.getClassLoader());
            if (!Resource.class.isAssignableFrom(clazz)) {
                throw new Exception(clazz + " is not a Resource.");
            }
            return this.loadInstance(true, featureElement, clazz);
        }
        if (featureElement.getNodeName().equals("ifdef")) {
            this.ifDef(featureElement, true);
            return null;
        }
        if (featureElement.getNodeName().equals("ifndef")) {
            this.ifDef(featureElement, false);
            return null;
        }
        if (featureElement.getNodeName().equals("property")) {
            XMLUtil.putVar(XMLUtil.getString(featureElement, "key"), XMLUtil.getString(featureElement, "value"));
            return null;
        }
        Class<? extends IResource> featureClass = this.typeMap.get(featureElement.getTagName());
        if (featureClass == null && (featureClass = Resources.getMapping(featureElement.getTagName())) == null) {
            throw new Exception("No mapping specified for " + featureElement.getTagName());
        }
        return this.loadInstance(false, featureElement, featureClass);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private IResource loadInstance(boolean isInstance, Element featureElement, Class<? extends IResource> featureClass) throws Exception {
        if (!ResourceConverter.$assertionsDisabled && !Resource.class.isAssignableFrom(featureClass)) {
            throw new AssertionError((Object)(String.valueOf(featureClass.getName()) + " is not a Resource"));
        }
        namedCtor = null;
        unnamedCtor = null;
        canBeUnNamed = false;
        canBeNamed = false;
        named = false;
        try {
            namedCtor = featureClass.getConstructor(ResourceConverter.namedSig);
            canBeNamed = true;
        }
        catch (NoSuchMethodException var9_9) {
            // empty catch block
        }
        try {
            unnamedCtor = featureClass.getConstructor(ResourceConverter.unnamedSig);
            canBeUnNamed = true;
        }
        catch (NoSuchMethodException var9_10) {
            // empty catch block
        }
        if (!canBeNamed && !canBeUnNamed) {
            throw new Exception("No suitable constructor found for " + featureElement.getTagName());
        }
        try {
            newFeature /* !! */  = null;
            name = null;
            name = featureElement.getAttribute("name");
            named = "".equals(name) == false;
            exists = false;
            wasCreated = false;
            if (this.overwrite && named && (exists = Resources.exists(name))) {
                newFeature /* !! */  = Resources.peek(name);
                if (newFeature /* !! */ .isLocked()) {
                    return newFeature /* !! */ ;
                }
                this.log("Reloading " + newFeature /* !! */ );
                wasCreated = newFeature /* !! */ .isCreated();
                if (wasCreated) {
                    newFeature /* !! */ .destroy();
                }
                newFeature /* !! */ .deregister();
            }
            if (newFeature /* !! */  == null) {
                if (canBeNamed && named && namedCtor != null) {
                    newFeature /* !! */  = namedCtor.newInstance(new Object[]{name});
                } else if (canBeUnNamed && !named && unnamedCtor != null) {
                    newFeature /* !! */  = unnamedCtor.newInstance(new Object[0]);
                } else {
                    if (canBeNamed && !named) {
                        throw new Exception("Resource has no 'name' attribute (a " + featureElement.getTagName() + "/" + featureClass.getName() + ")");
                    }
                    if (canBeUnNamed && named) {
                        throw new Exception("Resource cannot be named (a " + featureClass.getName() + ")");
                    }
                    throw new Exception("Something strange happened.");
                }
            }
            if (!named) {
                sb = new StringBuilder(64);
                sb.append(newFeature /* !! */ .getClass().getName());
                sb.append(ResourceConverter.uniqueNameCounter++);
                newFeature /* !! */ .setName(sb.toString());
            }
            try {
                newFeature /* !! */ .load(featureElement, this);
            }
            catch (Exception e) {
                System.err.println("Failed to load " + newFeature /* !! */  + " due to " + e);
                throw e;
            }
            if (!newFeature /* !! */ .isSubResource()) {
                if (exists) {
                    newFeature /* !! */ .register();
                    if (wasCreated) {
                        newFeature /* !! */ .create();
                    }
                    if (this.loadedListener != null) {
                        this.loadedListener.resourceLoaded(newFeature /* !! */ );
                    }
                } else {
                    if (!this.overwrite && Resources.exists(name)) {
                        throw new Exception("Resource " + newFeature /* !! */  + " has already been defined.");
                    }
                    Resources.put(newFeature /* !! */ );
                    if (this.loadedListener != null) {
                        this.loadedListener.resourceLoaded(newFeature /* !! */ );
                    }
                    this.log("Resource " + newFeature /* !! */  + ": loaded");
                }
            }
            return newFeature /* !! */ ;
        }
        catch (InstantiationException e) {
            e.printStackTrace(System.err);
            throw new Exception("Resource " + featureElement.getAttribute("name") + " [" + featureElement.getAttribute("class") + "] failed to instantiate.", e.getCause());
        }
        catch (Exception e) {
            this.log("Exception loading resource from tag " + featureElement.getNodeName());
            atts = featureElement.getAttributes();
            i = 0;
            ** while (i < atts.getLength())
        }
lbl-1000:
        // 1 sources

        {
            this.log("\tAttribute " + atts.item(i).getNodeName() + "=" + featureElement.getAttribute(atts.item(i).getNodeName()));
            ++i;
            continue;
        }
lbl89:
        // 1 sources

        throw e;
        catch (AssertionError e) {
            this.log("Exception loading resource from tag " + featureElement.getNodeName());
            atts = featureElement.getAttributes();
            i = 0;
            ** while (i < atts.getLength())
        }
lbl-1000:
        // 1 sources

        {
            this.log("\tAttribute " + atts.item(i).getNodeName() + "=" + featureElement.getAttribute(atts.item(i).getNodeName()));
            ++i;
            continue;
        }
lbl98:
        // 1 sources

        throw e;
    }

    @Override
    public void setLoadedListener(ResourceLoadedListener loadedListener) {
        this.loadedListener = loadedListener;
    }

    @Override
    public ResourceLoadedListener getLoadedListener() {
        return this.loadedListener;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public void pushMap(Map<String, Class<? extends IResource>> map) {
        this.stack.push(this.typeMap);
        this.typeMap = new HashMap<String, Class<? extends IResource>>(this.typeMap);
        this.typeMap.putAll(map);
        for (Map.Entry<String, Class<? extends IResource>> entry : this.typeMap.entrySet()) {
            String tag = entry.getKey();
            Class<? extends IResource> clazz = entry.getValue();
            Resources.registerTag(clazz, tag);
        }
    }

    @Override
    public Map<String, Class<? extends IResource>> popMap() {
        if (this.stack.size() == 0) {
            return null;
        }
        Map<String, Class<? extends IResource>> existingMap = this.typeMap;
        this.typeMap = this.stack.pop();
        return existingMap;
    }
}

