/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.IResource;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Element;

public class ResourceArray
extends Resource {
    private static final long serialVersionUID = 1L;
    private String[] resource;
    private IResource[] embedded;
    private transient IResource[] resourceInstance;

    public ResourceArray() {
    }

    public ResourceArray(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        List<Element> children = XMLUtil.getChildren(element, "item");
        this.resource = new String[children.size()];
        this.embedded = new IResource[children.size()];
        int i = 0;
        while (i < children.size()) {
            Element child = children.get(i);
            List<Element> subChildren = XMLUtil.getChildren(child);
            if (subChildren.size() == 1) {
                this.embedded[i] = loader.load(subChildren.get(0));
            } else {
                if (subChildren.size() > 1) {
                    throw new Exception("<item> tag cannot contain multiple sub-items");
                }
                this.resource[i] = child.getTextContent().trim();
            }
            ++i;
        }
    }

    protected void doCreate() {
        this.resourceInstance = new Resource[this.resource.length];
        int i = 0;
        while (i < this.resource.length) {
            if (this.embedded[i] != null) {
                this.resourceInstance[i] = this.embedded[i];
                this.embedded[i].create();
            } else {
                this.resourceInstance[i] = Resources.get(this.resource[i]);
            }
            ++i;
        }
    }

    protected void doDestroy() {
        int i = 0;
        while (i < this.resource.length) {
            if (this.embedded[i] != null) {
                this.embedded[i].destroy();
            }
            ++i;
        }
        this.resourceInstance = null;
    }

    public IResource getResource(int idx) {
        return this.resourceInstance[idx];
    }

    public int getNumResources() {
        return this.resourceInstance.length;
    }

    public void archive() {
        this.resource = null;
        this.embedded = null;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        int i = 0;
        while (i < this.resource.length) {
            writer.writeTag("item");
            if (this.resource[i] != null) {
                writer.writeText(this.resource[i]);
            } else if (this.embedded[i] != null) {
                ((Resource)this.embedded[i]).toXML(writer);
            }
            writer.closeTag();
            ++i;
        }
    }
}

