/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.ColorMapFeature;
import com.shavenpuppy.jglib.resources.ColorParser;
import com.shavenpuppy.jglib.resources.ReadableColorMap;
import com.shavenpuppy.jglib.util.Parseable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.ParseException;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class MappedColor
implements ReadableColor,
Parseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String mapName;
    private String colorName;
    private ReadableColor color;

    public MappedColor() {
    }

    public MappedColor(String def) {
        this.fromString(def);
    }

    public MappedColor(ReadableColor color) {
        this.color = color;
    }

    public void fromString(String src) {
        int idx = (src = src.toLowerCase()).indexOf(58);
        if (idx != -1) {
            this.mapName = src.substring(0, idx);
            this.colorName = src.substring(idx + 1, src.length());
        } else {
            try {
                this.colorName = null;
                this.color = ColorParser.parse(src);
            }
            catch (ParseException e) {
                this.mapName = null;
                this.colorName = src;
            }
        }
    }

    public String toString() {
        if (this.colorName != null) {
            return String.valueOf(this.mapName == null ? "" : String.valueOf(this.mapName) + ":") + this.colorName;
        }
        Color c = new Color(this.color);
        float[] hsv = c.toHSB(null);
        return "!" + (int)(hsv[0] * 255.0f) + "," + (int)(hsv[1] * 255.0f) + "," + (int)(hsv[2] * 255.0f) + "," + this.color.getAlpha();
    }

    private ReadableColor getColor() {
        if (this.color == null) {
            ReadableColorMap colorMap = this.mapName == null ? ColorMapFeature.getDefaultColorMap() : (ReadableColorMap)Resources.get(this.mapName);
            if (colorMap != null) {
                this.color = colorMap.getColor(this.colorName);
            }
            if (this.color == null) {
                this.color = ReadableColor.WHITE;
            }
        }
        return this.color;
    }

    public String getColorName() {
        return this.colorName;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setColor(ReadableColor newColor) {
        this.color = newColor;
    }

    public int getAlpha() {
        return this.getColor().getAlpha();
    }

    public byte getAlphaByte() {
        return this.getColor().getAlphaByte();
    }

    public int getBlue() {
        return this.getColor().getBlue();
    }

    public byte getBlueByte() {
        return this.getColor().getBlueByte();
    }

    public int getGreen() {
        return this.getColor().getGreen();
    }

    public byte getGreenByte() {
        return this.getColor().getGreenByte();
    }

    public int getRed() {
        return this.getColor().getRed();
    }

    public byte getRedByte() {
        return this.getColor().getRedByte();
    }

    public void writeABGR(ByteBuffer dest) {
        this.getColor().writeABGR(dest);
    }

    public void writeARGB(ByteBuffer dest) {
        this.getColor().writeARGB(dest);
    }

    public void writeBGR(ByteBuffer dest) {
        this.getColor().writeBGR(dest);
    }

    public void writeBGRA(ByteBuffer dest) {
        this.getColor().writeBGRA(dest);
    }

    public void writeRGB(ByteBuffer dest) {
        this.getColor().writeRGB(dest);
    }

    public void writeRGBA(ByteBuffer dest) {
        this.getColor().writeRGBA(dest);
    }
}

