/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.lwjgl.util.Color;

public abstract class ColorParser {
    private ColorParser() {
    }

    public static Color parse(String in) throws ParseException {
        Color ret = new Color();
        try {
            StringTokenizer st;
            if (in.startsWith("!")) {
                st = new StringTokenizer(in.substring(1), ", \t", false);
                if (!st.hasMoreTokens()) {
                    throw new ParseException("Missing hue value.", 0);
                }
                int h = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) {
                    throw new ParseException("Missing saturation value.", 0);
                }
                int s = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) {
                    throw new ParseException("Missing brightness value.", 0);
                }
                int b = Integer.parseInt(st.nextToken());
                ret.fromHSB((float)h / 255.0f, (float)s / 255.0f, (float)b / 255.0f);
            } else {
                st = new StringTokenizer(in, ", \t", false);
                if (!st.hasMoreTokens()) {
                    throw new ParseException("Missing red value.", 0);
                }
                ret.setRed(Integer.parseInt(st.nextToken()));
                if (!st.hasMoreTokens()) {
                    throw new ParseException("Missing green value.", 0);
                }
                ret.setGreen(Integer.parseInt(st.nextToken()));
                if (st.hasMoreTokens()) {
                    ret.setBlue(Integer.parseInt(st.nextToken()));
                } else {
                    throw new ParseException("Missing blue value.", 0);
                }
            }
            if (st.hasMoreTokens()) {
                ret.setAlpha(Integer.parseInt(st.nextToken()));
            } else {
                ret.setAlpha(255);
            }
            return ret;
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

