/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ColorParser;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.ReadableColorMap;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorMapFeature
extends Feature
implements ReadableColorMap {
    private static final long serialVersionUID = -5807833249115496127L;
    private static ColorMapFeature defaultColorMap;
    private SortedMap<ColorName, Color> colorNameMap;
    private Map<String, Color> colorMap;
    private boolean hsb = true;
    private boolean default_;

    public ColorMapFeature() {
    }

    public ColorMapFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public static ColorMapFeature getDefaultColorMap() {
        return defaultColorMap;
    }

    @Override
    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List<Element> colors = XMLUtil.getChildren(element, "color");
        this.colorNameMap = new TreeMap<ColorName, Color>();
        this.colorMap = new HashMap<String, Color>();
        int count = 0;
        for (Element color : colors) {
            String id = XMLUtil.getString(color, "id");
            int order = XMLUtil.getInt(color, "order", count++);
            Color c = ColorParser.parse(XMLUtil.getString(color, "c"));
            this.colorNameMap.put(new ColorName(id, order), c);
            this.colorMap.put(id, c);
        }
    }

    @Override
    protected boolean shouldWriteAttribute(String attribute) {
        if (attribute.equals("autoCreated") || attribute.equals("colorMap") || attribute.equals("colorNameMap")) {
            return false;
        }
        return super.shouldWriteAttribute(attribute);
    }

    @Override
    protected void doWriteChildren(XMLResourceWriter writer) throws IOException {
        boolean isCompact = writer.isCompact();
        writer.setCompact(true);
        for (Map.Entry<ColorName, Color> e : this.colorNameMap.entrySet()) {
            ColorName cn = e.getKey();
            Color value = e.getValue();
            writer.writeTag("color");
            writer.writeAttribute("id", cn.name, true);
            writer.writeAttribute("order", cn.order);
            if (this.hsb) {
                float[] colorHSB = value.toHSB(null);
                writer.writeAttribute("c", "!" + (int)(255.0f * colorHSB[0]) + "," + (int)(255.0f * colorHSB[1]) + "," + (int)(255.0f * colorHSB[2]) + "," + value.getAlpha());
            } else {
                writer.writeAttribute("c", String.valueOf(value.getRed()) + "," + value.getGreen() + "," + value.getBlue() + "," + value.getAlpha());
            }
            writer.closeTag();
        }
        writer.setCompact(isCompact);
    }

    @Override
    public ReadableColor getColor(String name) {
        return (ReadableColor)this.colorMap.get(name);
    }

    public void setColor(String name, ReadableColor newColor) {
        Color oldColor = this.colorMap.get(name = name.toLowerCase());
        if (oldColor == null) {
            oldColor = new Color();
            this.colorMap.put(name, oldColor);
            this.colorNameMap.put(new ColorName(name, this.colorNameMap.size()), oldColor);
        }
        oldColor.setColor(newColor);
    }

    public SortedMap<ColorName, Color> getColorNameMap() {
        return this.colorNameMap;
    }

    public void copy(ReadableColorMap source) {
        for (String name : source.getNames()) {
            this.setColor(name, source.getColor(name));
        }
    }

    @Override
    public Set<String> getNames() {
        return this.colorMap.keySet();
    }

    @Override
    protected void doRegister() {
        super.doRegister();
        if (this.default_) {
            defaultColorMap = this;
        }
    }

    @Override
    protected void doDeregister() {
        super.doDeregister();
        if (this.default_) {
            defaultColorMap = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColorName
    implements Serializable,
    Comparable<ColorName> {
        private static final long serialVersionUID = 1L;
        public final String name;
        public final int order;

        public ColorName(String name, int order) {
            this.name = name.toLowerCase();
            this.order = order;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(ColorName c) {
            if (this.order < c.order) {
                return -1;
            }
            if (this.order > c.order) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColorName other = (ColorName)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

