/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class OrthoCamera {
    protected Vector2f position = new Vector2f(0.0f, 0.0f);
    protected float halfWidth;
    protected float halfHeight;

    public OrthoCamera() {
        this.halfWidth = (float)Display.getDisplayMode().getWidth() / 2.0f;
        this.halfHeight = (float)Display.getDisplayMode().getHeight() / 2.0f;
    }

    public OrthoCamera(float width, float height) {
        this.halfWidth = width / 2.0f;
        this.halfHeight = height / 2.0f;
    }

    public void preRender() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)(-this.halfWidth), (double)this.halfWidth, (double)(-this.halfHeight), (double)this.halfHeight, (double)-8.1f, (double)8.1f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int x = Math.round(this.position.x);
        int y = Math.round(this.position.y);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    public void postRender() {
        GL11.glPopMatrix();
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    public void addToPosition(float x, float y) {
        this.position.x += x;
        this.position.y += y;
    }

    public ReadableVector2f getPosition() {
        return this.position;
    }

    public Vector2f screenToWorld(ReadableVector2f screenPos) {
        Vector2f worldCoords = new Vector2f(screenPos);
        float pixelHalfW = (float)Display.getDisplayMode().getWidth() / 2.0f;
        float pixelHalfH = (float)Display.getDisplayMode().getHeight() / 2.0f;
        worldCoords.x -= pixelHalfW;
        worldCoords.y -= pixelHalfH;
        worldCoords.x /= pixelHalfW;
        worldCoords.y /= pixelHalfH;
        worldCoords.x *= this.halfWidth;
        worldCoords.y *= this.halfHeight;
        worldCoords.x += this.position.x;
        worldCoords.y += this.position.y;
        return worldCoords;
    }

    public boolean intersects(float x, float y, float width, float height) {
        return x <= this.position.x + this.halfWidth && x + width >= this.position.x - this.halfWidth && y <= this.position.y + this.halfHeight && y + height >= this.position.y - this.halfHeight;
    }
}

