/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.opengl.GLRenderableObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.OpenGLException;

public class GLVertexBufferObject
extends Resource
implements GLRenderableObject {
    private int size;
    private final int type;
    private final int usage;
    private transient int id;
    private transient boolean mapped;
    private transient boolean cleared;
    private transient ByteBuffer buffer;

    public GLVertexBufferObject(int size, int type, int usage) {
        this.size = size;
        this.type = type;
        this.usage = usage;
    }

    public GLVertexBufferObject(int type, int usage) {
        this.size = 0;
        this.type = type;
        this.usage = usage;
    }

    protected void doCreate() {
        this.id = ARBBufferObject.glGenBuffersARB();
    }

    public void clear() {
        if (!this.cleared) {
            ARBBufferObject.glBufferDataARB((int)this.type, (long)this.size, (int)this.usage);
            this.cleared = true;
        }
    }

    protected void doDestroy() {
        if (this.id != 0) {
            this.unmap();
            ARBBufferObject.glDeleteBuffersARB((int)this.id);
            this.id = 0;
        }
    }

    public ByteBuffer map(int size) {
        if (!this.mapped) {
            if (this.size != size) {
                this.size = size;
                this.clear();
            }
            if (this.buffer != null && this.buffer.capacity() < size) {
                this.buffer = null;
            }
            ByteBuffer old = this.buffer;
            this.buffer = ARBBufferObject.glMapBufferARB((int)this.type, (int)35001, (long)size, (ByteBuffer)this.buffer);
            if (this.buffer == null) {
                throw new OpenGLException("Failed to map buffer " + this);
            }
            if (this.buffer != old) {
                // empty if block
            }
            this.buffer.order(ByteOrder.nativeOrder()).clear().limit(size);
            this.mapped = true;
            this.cleared = false;
        }
        return this.buffer;
    }

    public ByteBuffer map() {
        if (!this.mapped) {
            assert (this.size > 0);
            this.clear();
            ByteBuffer old = this.buffer;
            this.buffer = ARBBufferObject.glMapBufferARB((int)this.type, (int)35001, (long)this.size, (ByteBuffer)this.buffer);
            if (this.buffer == null) {
                throw new OpenGLException("Failed to map a buffer " + this.size + " bytes long");
            }
            if (this.buffer != old) {
                // empty if block
            }
            this.buffer.order(ByteOrder.nativeOrder()).clear().limit(this.size);
            this.mapped = true;
            this.cleared = false;
        }
        return this.buffer;
    }

    public void orphan() {
        ARBBufferObject.glMapBufferARB((int)this.type, (int)this.usage, (long)this.size, null);
    }

    public boolean unmap() {
        if (this.mapped) {
            this.mapped = false;
            return ARBBufferObject.glUnmapBufferARB((int)this.type);
        }
        return true;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public String toString() {
        return "GLVertexBufferObject[" + this.id + ", " + this.size + ", " + this.isCreated() + "]";
    }

    public void render() {
        ARBBufferObject.glBindBufferARB((int)this.type, (int)this.id);
    }

    public int getID() {
        return this.id;
    }
}

