/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Font;
import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLGlyph;
import com.shavenpuppy.jglib.opengl.GLGlyphBuffer;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.opengl.GLUtil;
import com.shavenpuppy.jglib.resources.FontResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.net.URL;
import org.lwjgl.util.Point;
import org.lwjgl.util.WritablePoint;
import org.w3c.dom.Element;

public class GLFont
extends Resource
implements GLRenderable {
    private static final long serialVersionUID = 1L;
    private static final Point tempPoint = new Point();
    protected String url;
    protected boolean ascii;
    private int minMode;
    private int magMode;
    private float scale = 1.0f;
    protected transient FontResource fontResource;
    protected transient Font font;
    protected transient GLTexture texture;
    protected transient boolean discardFontImage;
    protected transient boolean discardFontResource;

    public GLFont(String name) {
        super(name);
    }

    public GLFont(String name, String url, boolean ascii) {
        super(name);
        this.url = url;
        this.ascii = ascii;
        this.discardFontImage = true;
        this.discardFontResource = true;
    }

    public GLFont(String name, Font font, boolean ascii) {
        super(name);
        if (font == null) {
            throw new NullPointerException("Null 'Font' parameter for GLFont " + name);
        }
        this.font = font;
        this.ascii = ascii;
        this.minMode = 9987;
        this.magMode = 9729;
        this.discardFontResource = true;
    }

    public GLFont(String name, FontResource fontResource, boolean ascii) {
        super(name);
        this.fontResource = fontResource;
        this.ascii = ascii;
    }

    protected void doCreate() {
        try {
            if (this.url != null) {
                if (this.url.startsWith("classpath:")) {
                    BufferedInputStream bis = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10)));
                    this.font = new Font();
                    this.font.readExternal(bis);
                    bis.close();
                } else if (this.url.startsWith("resource:")) {
                    this.fontResource = (FontResource)Resources.get(this.url.substring(9));
                } else {
                    BufferedInputStream bis = new BufferedInputStream(new URL(this.url).openStream());
                    this.font = new Font();
                    this.font.readExternal(bis);
                    bis.close();
                }
            }
            if (this.fontResource != null) {
                this.font = this.fontResource.getFont();
            }
            if (this.font == null) {
                throw new Exception("No font specified for GLFont " + this);
            }
            this.texture = new GLTexture(this.getName(), this.font.getImage(), 3553, 6410, this.minMode, this.magMode, false);
            this.texture.create();
            if (this.discardFontImage) {
                this.font.getImage().dispose();
            }
            if (this.discardFontResource) {
                this.fontResource = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create font " + this + " font:" + this.font + " minMode:" + GLUtil.recode(this.minMode) + " magMode:" + GLUtil.recode(this.magMode));
        }
    }

    protected void doDestroy() {
        this.texture.destroy();
        this.texture = null;
    }

    public int getAscent() {
        return (int)((float)this.font.getAscent() * this.scale);
    }

    public int getDescent() {
        return (int)((float)this.font.getDescent() * this.scale);
    }

    public Font getFont() {
        return this.font;
    }

    public float getScale() {
        return this.scale;
    }

    public int getHeight() {
        return (int)((float)(this.font.getAscent() + this.font.getDescent()) * this.scale);
    }

    public int getLeading() {
        return (int)((float)this.font.getLeading() * this.scale);
    }

    public GLBaseTexture getTexture() {
        assert (this.isCreated()) : this + " is not created yet";
        return this.texture;
    }

    public void render() {
        assert (this.isCreated()) : this + " is not created yet";
        this.texture.render();
    }

    public GLGlyphBuffer getGlyphBuffer(char[] text, int start, int end, GLGlyphBuffer buffer) {
        if (buffer == null || buffer.capacity() < end - start) {
            buffer = new GLGlyphBuffer(end - start);
        }
        int count = 0;
        Glyph last = null;
        int penX = 0;
        int i = start;
        while (i < end) {
            Glyph next = this.font.map(text[i]);
            if (buffer.glyph[count] == null) {
                buffer.glyph[count] = new GLGlyph(this.texture, next, this.scale);
            } else {
                buffer.glyph[count].init(this.texture, next);
            }
            next.getBearing((WritablePoint)tempPoint);
            tempPoint.setLocation((int)((float)tempPoint.getX() * this.scale), (int)((float)tempPoint.getY() * this.scale));
            int kerning = (int)((float)next.getKerningAfter(last) * this.scale);
            buffer.glyph[count++].setLocation(tempPoint.getX() + penX - kerning, tempPoint.getY());
            penX += (int)((float)next.getAdvance() * this.scale) + kerning;
            last = next;
            ++i;
        }
        buffer.length = count;
        return buffer;
    }

    public GLGlyph map(char c) {
        return new GLGlyph(this.texture, this.font.map(c), this.scale);
    }

    public void archive() {
        this.url = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = XMLUtil.getString(element, "url");
        this.ascii = XMLUtil.getBoolean(element, "ascii", true);
        this.scale = XMLUtil.getFloat(element, "scale", 1.0f);
        String minModeS = XMLUtil.getString(element, "minmode", null);
        String magModeS = XMLUtil.getString(element, "magmode", null);
        this.minMode = minModeS != null ? GLUtil.decode(minModeS) : 9987;
        this.magMode = magModeS != null ? GLUtil.decode(magModeS) : 9729;
    }
}

