/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.openal.ALSource;
import com.shavenpuppy.jglib.openal.ALStreamInstance;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.InputStream;
import java.util.ArrayList;
import org.lwjgl.openal.AL;
import org.w3c.dom.Element;

public class ALStream
extends Resource {
    private static final long serialVersionUID = 1L;
    private static final ArrayList<ALStreamInstance> POOL = new ArrayList();
    protected String url;
    protected float gain;
    protected float pitch;
    protected int priority;
    protected boolean looped;
    private transient int format;
    private transient InputStream inputStream;

    public ALStream() {
    }

    public ALStream(String name) {
        super(name);
    }

    public ALStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.gain = 1.0f;
        this.pitch = 1.0f;
        this.priority = Integer.MAX_VALUE;
    }

    public int getFormat() {
        return this.format;
    }

    protected void doCreate() {
        if (!AL.isCreated()) {
            return;
        }
        ALStreamInstance ret = new ALStreamInstance(this);
        ret.create();
        this.format = ret.getFormat();
        ret.destroy();
    }

    protected void doDestroy() {
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.url = element.getAttribute("url");
        String gainS = element.getAttribute("gain");
        this.gain = gainS != null && !"".equals(gainS) ? Float.parseFloat(gainS) : 1.0f;
        String pitchS = element.getAttribute("pitch");
        this.pitch = pitchS != null && !"".equals(pitchS) ? Float.parseFloat(pitchS) : 1.0f;
        try {
            this.priority = Integer.parseInt(element.getAttribute("priority"));
        }
        catch (NumberFormatException e) {
            throw new Exception(this + " has no priority specified.");
        }
        this.looped = XMLUtil.getBoolean(element, "looped", false);
    }

    public String toString() {
        return "ALStream[" + this.url + "]";
    }

    public float getGain() {
        return this.gain;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isLooped() {
        return this.looped;
    }

    public String getURL() {
        return this.url;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ALStreamInstance getInstance(ALSource source) throws Exception {
        int i = 0;
        while (i < POOL.size()) {
            ALStreamInstance ret = POOL.get(i);
            if (!ret.isPlaying()) {
                ret.setOwner(source);
                ret.init(this);
                ret.reset();
                return ret;
            }
            ++i;
        }
        ALStreamInstance ret = new ALStreamInstance(this);
        ret.create();
        ret.setOwner(source);
        POOL.add(ret);
        return ret;
    }
}

