/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.MultiBuffer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;

public class AL {
    private static final Map<String, Integer> AL_CONSTANTS_MAP = new HashMap<String, Integer>(513, 1.0f);
    private static boolean constantsLoaded;
    public static final MultiBuffer scratch;

    static {
        AL.loadALConstants();
        scratch = new MultiBuffer(1024);
    }

    public static int decode(String alstring) {
        Integer i = AL_CONSTANTS_MAP.get(alstring.toUpperCase());
        if (i == null) {
            throw new OpenALException(String.valueOf(alstring) + " is not a recognised AL constant");
        }
        return i;
    }

    public static String recode(int code) {
        for (String s : AL_CONSTANTS_MAP.keySet()) {
            Integer n = AL_CONSTANTS_MAP.get(s);
            if (n != code) continue;
            return s;
        }
        throw new OpenALException(String.valueOf(code) + " is not a known AL code");
    }

    private static void loadALConstants() {
        if (constantsLoaded) {
            return;
        }
        Class<AL10> intf = AL10.class;
        Field[] field = intf.getFields();
        int i = 0;
        while (i < field.length) {
            try {
                if (Modifier.isStatic(field[i].getModifiers()) && Modifier.isPublic(field[i].getModifiers()) && Modifier.isFinal(field[i].getModifiers()) && field[i].getType().equals(Integer.TYPE)) {
                    AL_CONSTANTS_MAP.put(field[i].getName(), new Integer(field[i].getInt(null)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        constantsLoaded = true;
    }

    public static int translateFormat(int waveType) {
        int format;
        switch (waveType) {
            case 0: {
                format = 4352;
                break;
            }
            case 1: {
                format = 4353;
                break;
            }
            case 2: {
                format = 4354;
                break;
            }
            case 3: {
                format = 4355;
                break;
            }
            default: {
                throw new OpenALException("Unknown wave format.");
            }
        }
        return format;
    }
}

