/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.algorithms;

public final class Bresenham {
    private int dx;
    private int dy;
    private int error;
    private int x_inc;
    private int y_inc;
    private int xx;
    private int yy;
    private int length;
    private int count;
    private static final Bresenham bresenham = new Bresenham();

    public int plot(int x1, int y1, int x2, int y2) {
        this.dx = x2 - x1;
        this.dy = y2 - y1;
        if (this.dx >= 0) {
            this.x_inc = 1;
        } else {
            this.x_inc = -1;
            this.dx = -this.dx;
        }
        if (this.dy >= 0) {
            this.y_inc = 1;
        } else {
            this.y_inc = -1;
            this.dy = -this.dy;
        }
        this.xx = x1;
        this.yy = y1;
        this.error = this.dx > 0 ? this.dx >> 1 : this.dy >> 1;
        this.count = 0;
        this.length = Math.max(this.dx, this.dy) + 1;
        return this.length;
    }

    public boolean hasNext() {
        return this.count < this.length;
    }

    public boolean next() {
        if (this.count >= this.length) {
            throw new RuntimeException("No more points");
        }
        if (this.dx > this.dy) {
            this.error += this.dy;
            if (this.error >= this.dx) {
                this.error -= this.dx;
                this.yy += this.y_inc;
            }
            this.xx += this.x_inc;
        } else {
            this.error += this.dx;
            if (this.error >= this.dy) {
                this.error -= this.dy;
                this.xx += this.x_inc;
            }
            this.yy += this.y_inc;
        }
        ++this.count;
        return this.count < this.length;
    }

    public int getX() {
        return this.xx;
    }

    public int getY() {
        return this.yy;
    }

    public static final int plot(int x1, int y1, int x2, int y2, int[] x, int[] y) {
        int length = Math.min(x.length, Math.min(y.length, bresenham.plot(x1, y1, x2, y2)));
        int i = 0;
        while (i < length) {
            bresenham.next();
            x[i] = bresenham.getX();
            y[i] = bresenham.getY();
            ++i;
        }
        return length;
    }
}

