/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import java.io.Serializable;

public class Point2f
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float x;
    private float y;

    public Point2f() {
    }

    public Point2f(float x, float y) {
        this.setLocation(x, y);
    }

    public Point2f(Point2f p) {
        this.setLocation(p);
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point2f p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void translate(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void translate(Point2f p) {
        this.x += p.getX();
        this.y += p.getY();
    }

    public void untranslate(Point2f p) {
        this.x -= p.getX();
        this.y -= p.getY();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point2f) {
            Point2f pt = (Point2f)obj;
            return this.x == pt.x && this.y == pt.y;
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[x=" + this.x + ",y=" + this.y + "]";
    }

    public int hashCode() {
        int sum = Float.floatToRawIntBits(this.x) + Float.floatToRawIntBits(this.y);
        return sum * (sum + 1) / 2 + (int)this.x;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void getLocation(Point2f dest) {
        dest.setLocation(this.x, this.y);
    }
}

