/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.DirectBufferAllocator;
import com.shavenpuppy.jglib.WrappedBuffer;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Image
implements Serializable,
ImageWrapper {
    private static final long serialVersionUID = 8L;
    private static final int MAGIC = 4660;
    private static JPEGCompressor compressor;
    private static JPEGDecompressor decompressor;
    public static final int RGB = 0;
    public static final int RGBA = 1;
    public static final int LUMINANCE = 2;
    public static final int LUMINANCE_ALPHA = 3;
    public static final int ARGB = 4;
    public static final int ABGR = 5;
    public static final int BGR = 6;
    public static final int BGRA = 7;
    private static final int[] TYPE_TO_SIZE;
    private transient WrappedBuffer wrappedData;
    private transient ByteBuffer data;
    private transient int width;
    private transient int height;
    private transient int type;
    private transient boolean useJPEG;

    static {
        TYPE_TO_SIZE = new int[]{3, 4, 1, 2, 4, 4, 3, 4};
    }

    public Image() {
    }

    public void dispose() {
        this.data = null;
        this.wrappedData.dispose();
    }

    public Image(int width, int height, int type) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.wrappedData = DirectBufferAllocator.allocate(width * height * TYPE_TO_SIZE[type]);
        this.data = this.wrappedData.getBuffer();
    }

    public Image(int width, int height, int type, byte[] img) {
        this.width = width;
        this.height = height;
        this.type = type;
        assert (width * height * TYPE_TO_SIZE[type] == img.length) : "Image is incorrect size.";
        this.wrappedData = DirectBufferAllocator.allocate(img.length);
        this.data = this.wrappedData.getBuffer();
        this.data.put(img);
        this.data.flip();
    }

    public Image(int width, int height, int type, ByteBuffer imageData) {
        this.width = width;
        this.height = height;
        this.type = type;
        assert (width * height * TYPE_TO_SIZE[type] == imageData.remaining()) : "Image is incorrect size.";
        assert (imageData.isDirect()) : "Image must be stored in a direct byte buffer.";
        this.data = imageData.slice();
    }

    public static Image read(InputStream is) throws Exception {
        Image ret = new Image();
        ret.readExternal(new DataInputStream(is));
        return ret;
    }

    public static void write(Image image, OutputStream os) throws Exception {
        image.writeExternal(os);
    }

    public void writeExternal(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        this.doWrite(dos);
        dos.flush();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        DataOutputStream dos = new DataOutputStream(stream);
        this.doWrite(dos);
        dos.flush();
    }

    private void doWrite(DataOutputStream stream) throws IOException {
        stream.writeInt(4660);
        stream.writeInt(this.width);
        stream.writeInt(this.height);
        stream.writeInt(this.type);
        stream.writeInt(this.useJPEG ? 1 : 0);
        this.data.rewind();
        if (this.useJPEG && this.hasAlpha() && TYPE_TO_SIZE[this.type] == 4) {
            ByteBuffer compressed;
            ByteBuffer bgr = this.extractBGR();
            try {
                compressed = compressor.compress(this.width, this.height, bgr);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Failed to compress: " + e.getMessage());
            }
            stream.writeInt(compressed.capacity());
            System.out.println("Compressed image to " + compressed.capacity() + " bytes, down from " + this.width * this.height * 4);
            stream.write(compressed.array());
            compressed = this.createAlphaDelta();
            stream.write(compressed.array());
        } else if (this.useJPEG && !this.hasAlpha() && TYPE_TO_SIZE[this.type] == 3) {
            ByteBuffer compressed;
            try {
                compressed = compressor.compress(this.width, this.height, this.data);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Failed to compress: " + e.getMessage());
            }
            stream.writeInt(compressed.capacity());
            System.out.println("Compressed image to " + compressed.capacity() + " bytes, down from " + this.width * this.height * 3);
            stream.write(compressed.array());
        } else {
            byte[] buf = new byte[this.data.limit() - this.data.position()];
            this.data.get(buf);
            this.data.flip();
            stream.writeInt(buf.length);
            stream.write(buf);
        }
    }

    public void readExternal(InputStream is) throws IOException {
        DataInputStream stream = new DataInputStream(is);
        int magic = stream.readInt();
        if (magic != 4660) {
            throw new IOException("Stream corrupt - expected magic number 4660 but got " + magic);
        }
        this.width = stream.readInt();
        if (this.width <= 0) {
            throw new IOException("Illegal width: got " + this.width);
        }
        this.height = stream.readInt();
        if (this.height <= 0) {
            throw new IOException("Illegal height: got " + this.height);
        }
        this.type = stream.readInt();
        if (this.type < 0 || this.type > 7) {
            throw new IOException("Illegal type: got " + this.type);
        }
        this.useJPEG = stream.readInt() == 1;
        int length = this.width * this.height * TYPE_TO_SIZE[this.type];
        this.wrappedData = DirectBufferAllocator.allocate(length);
        this.data = this.wrappedData.getBuffer();
        if (this.useJPEG && this.hasAlpha() && TYPE_TO_SIZE[this.type] == 4) {
            int compressedSize = stream.readInt();
            ByteBuffer compressed = ByteBuffer.allocate(compressedSize);
            byte[] buf = new byte[compressedSize];
            stream.readFully(buf);
            compressed.put(buf);
            compressed.flip();
            ByteBuffer uncompressed = ByteBuffer.allocateDirect(this.width * this.height * 3);
            try {
                decompressor.decompress(compressed, uncompressed);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Failed to decompress: " + e.getMessage(), e);
            }
            this.insertBGR(uncompressed);
            ByteBuffer alphaDelta = ByteBuffer.allocate(this.width * this.height);
            buf = null;
            buf = new byte[this.width * this.height];
            stream.readFully(buf);
            alphaDelta.put(buf).flip();
            this.mergeAlphaDelta(alphaDelta);
        } else if (this.useJPEG && !this.hasAlpha() && TYPE_TO_SIZE[this.type] == 3) {
            int compressedSize = stream.readInt();
            ByteBuffer compressed = ByteBuffer.allocate(compressedSize);
            byte[] buf = new byte[compressedSize];
            stream.readFully(buf);
            compressed.put(buf);
            compressed.flip();
            this.data = ByteBuffer.allocateDirect(this.width * this.height * 3);
            try {
                decompressor.decompress(compressed, this.data);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Failed to decompress: " + e.getMessage(), e);
            }
            this.data.rewind();
        } else {
            int actualLength = stream.readInt();
            if (actualLength != length) {
                throw new IOException("Corrupt: expected length " + length + ", but read " + actualLength + " from stream");
            }
            byte[] buf = new byte[length];
            stream.readFully(buf);
            this.data.put(buf);
            this.data.flip();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        DataInputStream dis = new DataInputStream(stream);
        this.readExternal(dis);
    }

    private ByteBuffer extractBGR() {
        ByteBuffer ret = ByteBuffer.allocate(this.width * this.height * 3);
        int n = this.width * this.height * 4;
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 2));
                    ret.put(this.data.get(i + 1));
                    ret.put(this.data.get(i + 0));
                    i += 4;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 0));
                    ret.put(this.data.get(i + 1));
                    ret.put(this.data.get(i + 2));
                    i += 4;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 3));
                    ret.put(this.data.get(i + 2));
                    ret.put(this.data.get(i + 1));
                    i += 4;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 1));
                    ret.put(this.data.get(i + 2));
                    ret.put(this.data.get(i + 3));
                    i += 4;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return ret;
    }

    private void insertBGR(ByteBuffer buf) {
        int n = this.width * this.height * 4;
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 2, buf.get());
                    this.data.put(i + 1, buf.get());
                    this.data.put(i + 0, buf.get());
                    i += 4;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 0, buf.get());
                    this.data.put(i + 1, buf.get());
                    this.data.put(i + 2, buf.get());
                    i += 4;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 3, buf.get());
                    this.data.put(i + 2, buf.get());
                    this.data.put(i + 1, buf.get());
                    i += 4;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 1, buf.get());
                    this.data.put(i + 2, buf.get());
                    this.data.put(i + 3, buf.get());
                    i += 4;
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private ByteBuffer createAlphaDelta() {
        ByteBuffer buf = ByteBuffer.allocate(this.width * this.height);
        int pos = this.type == 1 || this.type == 7 ? 3 : 0;
        int y = 0;
        while (y < this.height) {
            byte o0 = 0;
            byte n0 = 0;
            int x = 0;
            while (x < this.width) {
                n0 = this.data.get(pos);
                buf.put((byte)(n0 - o0));
                o0 = n0;
                pos += 4;
                ++x;
            }
            ++y;
        }
        return buf;
    }

    private void mergeAlphaDelta(ByteBuffer buf) {
        int pos = this.type == 1 || this.type == 7 ? 3 : 0;
        int y = 0;
        while (y < this.height) {
            int o0 = 0;
            int x = 0;
            while (x < this.width) {
                this.data.put(pos, (byte)(o0 += buf.get()));
                pos += 4;
                ++x;
            }
            ++y;
        }
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Image [width=");
        buffer.append(this.width);
        buffer.append(", height=");
        buffer.append(this.height);
        buffer.append(", type=");
        buffer.append(this.type);
        buffer.append(", useJPEG=");
        buffer.append(this.useJPEG);
        buffer.append("]");
        return buffer.toString();
    }

    public void setUseJPEG(boolean useJPEG) {
        this.useJPEG = useJPEG;
    }

    public static void setCompressor(JPEGCompressor compressor) {
        Image.compressor = compressor;
    }

    public static void setDecompressor(JPEGDecompressor decompressor) {
        Image.decompressor = decompressor;
    }

    public boolean hasAlpha() {
        return this.type == 3 || this.type == 1 || this.type == 4 || this.type == 5 || this.type == 7;
    }

    public Image getImage() {
        return this;
    }

    public static interface JPEGCompressor {
        public ByteBuffer compress(int var1, int var2, ByteBuffer var3) throws Exception;
    }

    public static interface JPEGDecompressor {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws Exception;
    }
}

