/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.WritableDimension;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public final class Glyph
implements Serializable,
ReadableRectangle {
    private static final long serialVersionUID = 1L;
    private static final int MAGIC = 13398;
    private char character;
    private int advance;
    private int height;
    private int width;
    private int x;
    private int y;
    private int bearingX;
    private int bearingY;
    private char[] kernsWith;
    private int[] kerning;

    public void writeExternal(OutputStream os) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(13398);
        dos.writeChar(this.character);
        dos.writeInt(this.advance);
        dos.writeInt(this.width);
        dos.writeInt(this.height);
        dos.writeInt(this.x);
        dos.writeInt(this.y);
        dos.writeInt(this.bearingX);
        dos.writeInt(this.bearingY);
        if (this.kernsWith == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.kernsWith.length);
            objectArray = this.kernsWith;
            n2 = this.kernsWith.length;
            n = 0;
            while (n < n2) {
                char c = objectArray[n];
                dos.writeChar(c);
                ++n;
            }
        }
        if (this.kerning == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.kerning.length);
            objectArray = this.kerning;
            n2 = this.kerning.length;
            n = 0;
            while (n < n2) {
                char i = objectArray[n];
                dos.writeInt(i);
                ++n;
            }
        }
    }

    public void readExternal(InputStream is) throws IOException {
        int numKerning;
        DataInputStream dis = new DataInputStream(is);
        int magic = dis.readInt();
        if (magic != 13398) {
            throw new IOException("Expected 13398 but got " + magic);
        }
        this.character = dis.readChar();
        this.advance = dis.readInt();
        this.width = dis.readInt();
        this.height = dis.readInt();
        this.x = dis.readInt();
        this.y = dis.readInt();
        this.bearingX = dis.readInt();
        this.bearingY = dis.readInt();
        int numKerns = dis.readInt();
        if (numKerns > 0) {
            this.kernsWith = new char[numKerns];
            int i = 0;
            while (i < this.kernsWith.length) {
                this.kernsWith[i] = dis.readChar();
                ++i;
            }
        }
        if ((numKerning = dis.readInt()) > 0) {
            this.kerning = new int[numKerning];
            int i = 0;
            while (i < this.kerning.length) {
                this.kerning[i] = dis.readInt();
                ++i;
            }
        }
    }

    public void init(char character, int x, int y, int width, int height, int bearingX, int bearingY, int advance, Glyph[] kernsWith, int[] kerning) {
        this.character = character;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bearingX = bearingX;
        this.bearingY = bearingY;
        this.advance = advance;
        if (kernsWith != null) {
            this.kernsWith = new char[kernsWith.length];
            int i = 0;
            while (i < kernsWith.length) {
                this.kernsWith[i] = kernsWith[i].character;
                ++i;
            }
        } else {
            this.kernsWith = null;
        }
        this.kerning = kerning;
    }

    public int getKerningAfter(Glyph g) {
        if (g == null) {
            return 0;
        }
        if (this.kernsWith == null) {
            return 0;
        }
        int i = 0;
        while (i < this.kernsWith.length) {
            if (this.kernsWith[i] == g.character) {
                return this.kerning[i];
            }
            ++i;
        }
        return 0;
    }

    public void getBounds(WritableRectangle dest) {
        dest.setBounds(this.x, this.y, this.width, this.height);
    }

    public void getBearing(WritablePoint dest) {
        dest.setLocation(this.bearingX, this.bearingY);
    }

    public int getAdvance() {
        return this.advance;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBearingX() {
        return this.bearingX;
    }

    public int getBearingY() {
        return this.bearingY;
    }

    public void getSize(WritableDimension dest) {
        dest.setSize(this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void getLocation(WritablePoint dest) {
        dest.setLocation(this.x, this.y);
    }
}

