/*
 * Decompiled with CFR 0.152.
 */
package invaders.powerups;

import invaders.GameScreen;
import invaders.Player;
import invaders.Powerup;
import invaders.PowerupFeature;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class InvulnerabilityPowerupFeature
extends PowerupFeature {
    private static final long serialVersionUID = 1L;
    private int duration;
    private static final Color LABEL_COLOR = new Color(107, 255, 0, 255);
    private static PowerupFeature instance;

    public InvulnerabilityPowerupFeature(String name) {
        super(name);
    }

    protected Powerup createInstance() {
        return new InvulnerabilityPowerup(this);
    }

    protected void doRegister() {
        super.doRegister();
        instance = this;
    }

    protected void doDeregister() {
        super.doDeregister();
        instance = null;
    }

    public static PowerupFeature getInstance() {
        return instance;
    }

    private class InvulnerabilityPowerup
    extends PowerupFeature.PowerupInstance {
        private static final long serialVersionUID = 1L;

        protected InvulnerabilityPowerup(PowerupFeature feature) {
            super(feature);
        }

        public void onCollisionWithPlayer(Player player) {
            player.enableInvulnerability(InvulnerabilityPowerupFeature.this.duration);
            LabelEffect effect = new LabelEffect(Res.getSmallFont(), "SUPERSHIELD", ReadableColor.WHITE, (ReadableColor)LABEL_COLOR, 90, 30);
            effect.spawn((Screen)GameScreen.getInstance());
            effect.setLocation((float)((int)this.getX()), 10.0f);
            effect.setVelocity(0.0f, 0.4f);
            effect.setAcceleration(0.0f, -0.0075f);
            this.pop();
        }
    }
}

