/*
 * Decompiled with CFR 0.152.
 */
package invaders.effects;

import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.util.ShortList;
import invaders.Res;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;

public class SmartbombEffect
extends Effect {
    private static final int DURATION = 60;
    private static final float RADIUS = 500.0f;
    private static final float WIDTH = 128.0f;
    private float radius;
    private int tick;
    private float x;
    private float y;
    private final ShortList indices = new ShortList(45);

    public SmartbombEffect(float x, float y) {
        this.x = x;
        this.y = y;
    }

    protected void doTick() {
        ++this.tick;
        this.radius = SineInterpolator.instance.interpolate(0.0f, 500.0f, (float)this.tick / 60.0f);
    }

    protected void render() {
        this.glRender(new GLRenderable(){

            public void render() {
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                GL11.glBlendFunc((int)770, (int)1);
                Res.getSmartBombTexture().render();
            }
        });
        float innerRadius = SineInterpolator.instance.interpolate(0.0f, Math.max(0.0f, 372.0f), (float)this.tick / 60.0f);
        boolean writeIndices = this.indices.size() == 0;
        short count = 0;
        float ox = this.getOffset().getX();
        float oy = this.getOffset().getY();
        int i = 0;
        while (i < 360) {
            this.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
            this.glTexCoord2f(i, 1.0f);
            this.glVertex2f(ox + this.x + (float)Math.cos(Math.toRadians(i)) * innerRadius, oy + this.y + (float)Math.sin(Math.toRadians(i)) * innerRadius);
            this.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.glTexCoord2f(i, 0.0f);
            this.glVertex2f(ox + this.x + (float)Math.cos(Math.toRadians(i)) * this.radius, oy + this.y + (float)Math.sin(Math.toRadians(i)) * this.radius);
            if (writeIndices) {
                short s = count;
                count = (short)(s + 1);
                this.indices.add(s);
                short s2 = count;
                count = (short)(s2 + 1);
                this.indices.add(s2);
            }
            i += 8;
        }
        if (writeIndices) {
            this.indices.add((short)0);
            this.indices.add((short)1);
            this.indices.trimToSize();
        }
        this.glRender(5, this.indices.array());
    }

    public boolean isEffectActive() {
        return this.tick < 60;
    }

    public float getRadius() {
        return this.radius;
    }
}

