/*
 * Decompiled with CFR 0.152.
 */
package invaders.effects;

import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.Util;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Invaders;
import invaders.Laser;
import invaders.Res;
import java.util.LinkedList;
import net.puppygames.applet.Game;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.widgets.Beam;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class LaserEffect
extends Effect
implements Laser {
    private static final GLRenderable SETUP = new GLRenderable(){

        public void render() {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            Res.getLaserTexture().render();
        }
    };
    private static final Color TEMP = new Color();
    private float offsetX;
    private float offsetY;
    private float x;
    private float y;
    private float tx;
    private float ty;
    private float width;
    private Color color;
    private int duration;
    private int tick;
    private boolean dangerous;
    private Beam beam;

    public LaserEffect(float width, Color color, int duration, float offsetX, float offsetY) {
        this.width = width;
        this.color = color;
        this.duration = duration;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setTarget(float tx, float ty) {
        this.tx = tx;
        this.ty = ty;
    }

    protected void doTick() {
        ++this.tick;
        this.dangerous = Util.random((int)0, (int)3) != 0;
        float x = GameScreen.getPlayer().getX() + this.offsetX;
        this.setLocation(x, GameScreen.getPlayer().getY() + this.offsetY);
        if (this.dangerous) {
            LinkedList entities = new LinkedList(Invaders.getGameState().getEntities());
            Entity lowest = null;
            for (Entity entity : entities) {
                if (!entity.canCollide() || !entity.canCollideWithLaser() || !(x >= entity.getX() - entity.getRadius()) || !(x <= entity.getX() + entity.getRadius()) || lowest != null && !(entity.getY() - entity.getRadius() < lowest.getY() - lowest.getRadius())) continue;
                lowest = entity;
            }
            if (lowest != null) {
                this.setTarget(x, lowest.getY());
                lowest.onCollisionWithLaser(this);
            } else {
                this.setTarget(x, GameScreen.getPlayer().getY() + this.offsetY + (float)Game.getScale());
            }
        }
    }

    protected void doSpawnEffect() {
        this.beam = new Beam();
        this.beam.setWidth(this.width);
    }

    protected void render() {
        if (!this.dangerous) {
            return;
        }
        this.glRender(SETUP);
        float ratio = (float)this.tick / (float)this.duration;
        float alphaRatio = LinearInterpolator.instance.interpolate(1.0f, 0.0f, ratio);
        float alpha = (float)this.color.getAlpha() * alphaRatio;
        float ox = GameScreen.getSpriteOffset().getX();
        float oy = GameScreen.getSpriteOffset().getY();
        this.beam.setLocation(this.x + ox, this.y + oy, this.tx + ox, this.ty + oy);
        ColorUtil.setAlpha((ReadableColor)ColorUtil.premultiply((ReadableColor)this.color, (int)((int)alpha), (Color)TEMP), (int)0, (Color)TEMP);
        this.beam.setWidth(CosineInterpolator.instance.interpolate(this.width, 0.1f, ratio));
        this.beam.setStartColor((ReadableColor)TEMP);
        this.beam.setEndColor((ReadableColor)TEMP);
        this.beam.render((SimpleRenderer)this);
    }

    public boolean isEffectActive() {
        return this.tick < this.duration;
    }

    public boolean isDangerous() {
        return this.dangerous;
    }

    public int getDefaultLayer() {
        return 9;
    }
}

