/*
 * Decompiled with CFR 0.152.
 */
package invaders.effects;

import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.ShortList;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;

public class ExplosionEffect
extends Effect {
    private float maxRadius;
    private int duration;
    private int fadeDuration;
    private int tick;
    private GLBaseTexture texture;
    private float x;
    private float y;
    private Interpolator interpolator;
    private float outerRadius;
    private float innerRadius;
    private Range angle;
    private final ShortList indices = new ShortList(80);

    public ExplosionEffect(float radius, int duration, int fadeDuration, GLBaseTexture texture, Interpolator interpolator, Range angle) {
        this.maxRadius = radius;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.texture = texture;
        this.interpolator = interpolator;
        this.angle = angle == null ? new Range(0.0f, 360.0f) : angle;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    protected void doTick() {
        ++this.tick;
        this.outerRadius = this.interpolator.interpolate(0.0f, this.maxRadius, (float)this.tick / (float)this.duration);
        this.innerRadius = this.interpolator.interpolate(0.0f, this.maxRadius, (float)(this.tick - this.duration) / (float)this.fadeDuration);
    }

    public float getRadius() {
        return this.outerRadius;
    }

    protected void render() {
        this.glRender(new GLRenderable(){

            public void render() {
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                GL11.glBlendFunc((int)770, (int)1);
                ExplosionEffect.this.texture.render();
            }
        });
        float alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)(this.tick - this.duration) / (float)(this.duration + this.fadeDuration));
        boolean writeIndices = this.indices.size() == 0;
        short count = 0;
        float i = this.angle.getMin();
        while (i <= this.angle.getMax()) {
            this.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
            this.glTexCoord2f(i, 1.0f);
            this.glVertex2f(this.x + (float)Math.cos(Math.toRadians(i)) * this.innerRadius, this.y + (float)Math.sin(Math.toRadians(i)) * this.innerRadius);
            this.glColor4f(1.0f, 1.0f, 1.0f, alpha);
            this.glTexCoord2f(i, 0.0f);
            this.glVertex2f(this.x + (float)Math.cos(Math.toRadians(i)) * this.outerRadius, this.y + (float)Math.sin(Math.toRadians(i)) * this.outerRadius);
            if (writeIndices) {
                short s = count;
                count = (short)(s + 1);
                this.indices.add(s);
                short s2 = count;
                count = (short)(s2 + 1);
                this.indices.add(s2);
            }
            i += 10.0f;
        }
        this.glRender(5, this.indices.toArray(null));
    }

    public boolean isEffectActive() {
        return this.tick < this.duration + this.fadeDuration;
    }

    public boolean isExploding() {
        return this.tick < this.duration;
    }
}

