/*
 * Decompiled with CFR 0.152.
 */
package invaders.effects;

import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.Util;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.widgets.Beam;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class AlienLaserEffect
extends Effect {
    private static final GLRenderable SETUP = new GLRenderable(){

        public void render() {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            Res.getLaserTexture().render();
        }
    };
    private static final Color TEMP = new Color();
    private Gidrah gidrah;
    private float width;
    private float x;
    private float y;
    private float tx;
    private float ty;
    private Color color;
    private int duration;
    private int tick;
    private boolean visible;
    private Beam beam;

    public AlienLaserEffect(float width, Color color, int duration, Gidrah gidrah) {
        this.width = width;
        this.color = color;
        this.duration = duration;
        this.gidrah = gidrah;
    }

    protected void doSpawnEffect() {
        this.beam = new Beam();
        this.beam.setWidth(this.width);
    }

    protected void doTick() {
        ++this.tick;
        this.visible = Util.random((int)0, (int)3) != 0;
        this.x = this.gidrah.getX();
        this.y = this.gidrah.getY();
        if (this.visible) {
            float r;
            float px = GameScreen.getPlayer().getX();
            if (this.x >= px - (r = GameScreen.getPlayer().getRadius()) && this.x <= px + r) {
                GameScreen.getPlayer().onCollisionWithAlienLaser(this);
                this.ty = 22.0f;
            } else {
                this.ty = 14.0f;
            }
            this.tx = this.x;
            Emitter e = Res.getAlienLaserEmitter().spawn((Screen)GameScreen.getInstance());
            e.setLocation(this.tx, this.ty - 2.0f);
            e.setFloor(10.0f);
        }
    }

    protected void render() {
        if (!this.visible) {
            return;
        }
        this.glRender(SETUP);
        float ratio = (float)this.tick / (float)this.duration;
        float alphaRatio = LinearInterpolator.instance.interpolate(1.0f, 0.0f, ratio);
        float alpha = (float)this.color.getAlpha() * alphaRatio;
        float ox = GameScreen.getSpriteOffset().getX();
        float oy = GameScreen.getSpriteOffset().getY();
        this.beam.setLocation(this.x + ox, this.y + oy, this.tx + ox, this.ty + oy);
        ColorUtil.setAlpha((ReadableColor)ColorUtil.premultiply((ReadableColor)this.color, (int)((int)alpha), (Color)TEMP), (int)0, (Color)TEMP);
        this.beam.setWidth(CosineInterpolator.instance.interpolate(this.width, 0.1f, ratio));
        this.beam.setStartColor((ReadableColor)TEMP);
        this.beam.setEndColor((ReadableColor)TEMP);
        this.beam.render((SimpleRenderer)this);
    }

    public boolean isEffectActive() {
        return this.gidrah.isActive() && this.tick < this.duration;
    }
}

