/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.Gidrah;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;

public class Random
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private float speed;
    private Range wait;
    private float floor = 64.0f;
    private boolean preferTop;

    public Random(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new Instance(this, gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathRandom();
    }

    private static class Instance
    extends Behaviour.Instance {
        private static final long serialVersionUID = 1L;
        private float ox;
        private float oy;
        private float tx;
        private float ty;
        private float vx;
        private int tick;
        private int moves;
        private int phase;
        private static final int PHASE_WAIT = 0;
        private static final int PHASE_MOVE = 1;
        private transient Random behaviour;

        public Instance(Random behaviour, Gidrah gidrah) {
            super(gidrah);
            this.behaviour = behaviour;
        }

        private void selectTarget() {
            double dy;
            double dx;
            double distance;
            this.ox = this.getGidrah().getX();
            this.oy = this.getGidrah().getY();
            do {
                int gidrahRadius = (int)this.getGidrah().getRadius();
                this.tx = Util.random((int)gidrahRadius, (int)(Game.getScale() - gidrahRadius));
                this.ty = this.behaviour.preferTop && Math.random() < 0.75 ? (float)Util.random((int)(gidrahRadius + (int)(10.0f + this.behaviour.floor * 3.0f)), (int)(Game.getScale() - (gidrahRadius + 80))) : (float)Util.random((int)(gidrahRadius + (int)(10.0f + this.behaviour.floor)), (int)(Game.getScale() - (gidrahRadius + 80)));
            } while ((distance = Math.sqrt((dx = (double)(this.ox - this.tx)) * dx + (dy = (double)(this.oy - this.ty)) * dy)) < 20.0);
            this.vx = (float)((double)(this.behaviour.speed * (this.tx - this.ox)) / distance);
            this.moves = (int)(distance / (double)this.behaviour.speed);
            this.phase = 1;
            this.tick = 0;
        }

        public float getVX() {
            if (this.phase == 1) {
                return this.vx;
            }
            return 0.0f;
        }

        protected void doTick() {
            switch (this.phase) {
                case 1: {
                    ++this.tick;
                    float ratio = (float)this.tick / (float)this.moves;
                    this.getGidrah().setLocation(LinearInterpolator.instance.interpolate(this.ox, this.tx, ratio), LinearInterpolator.instance.interpolate(this.oy, this.ty, ratio));
                    if (this.tick != this.moves) break;
                    this.phase = 0;
                    this.tick = (int)this.behaviour.wait.getValue();
                }
                case 0: {
                    --this.tick;
                    if (this.tick > 0) break;
                    this.selectTarget();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (Random)this.gidrah.getBehaviour();
        }
    }
}

