/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.SFX;
import invaders.behaviours.Compass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;

public class Lurch
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private static int MIN_HOMING_HEIGHT = 60;
    private float speed;
    private int move;
    private int wait;
    private boolean diagonal;
    private boolean homing;
    private float floor = 64.0f;
    private boolean preferTop;

    public Lurch(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new Instance(this, gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathLurch();
    }

    private static class Instance
    extends Behaviour.Instance
    implements Compass {
        private static final long serialVersionUID = 1L;
        private int tick;
        private boolean waiting = true;
        private int direction;
        private float dx;
        private float dy;
        private transient Lurch behaviour;

        public Instance(Lurch behaviour, Gidrah gidrah) {
            super(gidrah);
            this.behaviour = behaviour;
            this.tick = -Util.random((int)0, (int)behaviour.wait);
        }

        public void init() {
            if (this.behaviour.homing) {
                this.gidrah.setAutoRemove(false);
                this.gidrah.setLocation(Util.random((int)0, (int)Game.getScale()), (float)Game.getScale() + 16.0f * (float)this.gidrah.getInitialRow() + (float)Util.random((int)0, (int)13));
                this.tick = -this.gidrah.getInitialRow() * 60 - Invaders.getGameState().getMultiplier() * 3;
            }
        }

        private void chooseDirection() {
            if (this.behaviour.homing) {
                this.dx = GameScreen.getPlayer().getX() - this.gidrah.getX();
                this.dy = GameScreen.getPlayer().getY() - this.gidrah.getY();
                if (this.dy > (float)(-MIN_HOMING_HEIGHT)) {
                    this.dx = 0.0f;
                }
                if (this.dy > 0.0f) {
                    this.dy = -100.0f;
                }
                double dist = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
                this.dx *= this.behaviour.speed;
                this.dy *= this.behaviour.speed;
                this.dx = (float)((double)this.dx / dist);
                this.dy = (float)((double)this.dy / dist);
            } else {
                boolean safe;
                if (this.behaviour.preferTop && Math.random() < 0.75) {
                    this.direction = this.behaviour.diagonal ? Util.random((int)0, (int)1) * 2 + 1 : Util.random((int)0, (int)2) * 2;
                } else {
                    this.direction = Util.random((int)0, (int)3) * 2;
                    if (this.behaviour.diagonal) {
                        ++this.direction;
                    }
                }
                int count = 0;
                do {
                    this.dx = DX[this.direction] * this.behaviour.speed;
                    this.dy = DY[this.direction] * this.behaviour.speed;
                    float ddx = this.dx * (float)this.behaviour.move;
                    float ddy = this.dy * (float)this.behaviour.move;
                    boolean bl = safe = this.gidrah.getX() + ddx > this.gidrah.getRadius() && this.gidrah.getY() + ddy > this.gidrah.getRadius() + 10.0f + this.behaviour.floor && this.gidrah.getX() + ddx < (float)Game.getScale() - this.gidrah.getRadius() && this.gidrah.getY() + ddy < (float)Game.getScale() - (this.gidrah.getRadius() + 80.0f);
                    if (safe) continue;
                    this.direction += 2;
                    this.direction %= 8;
                } while (!safe && ++count < 4);
                if (!safe) {
                    this.gidrah.criticalHit();
                }
            }
        }

        protected void doTick() {
            ++this.tick;
            if (this.waiting) {
                if (this.tick < this.behaviour.wait) {
                    return;
                }
                this.tick = 0;
                this.waiting = false;
                this.chooseDirection();
            }
            if (this.tick < this.behaviour.move) {
                this.gidrah.setLocation(this.gidrah.getX() + this.dx, this.gidrah.getY() + this.dy);
                if (this.gidrah.getY() < -this.gidrah.getRadius() * 2.0f) {
                    this.gidrah.setLocation(this.gidrah.getX(), (float)Game.getScale() + this.gidrah.getRadius() * 2.0f);
                }
            } else {
                this.tick = 0;
                this.waiting = true;
            }
        }

        public float getVX() {
            if (this.waiting) {
                return 0.0f;
            }
            return this.dx;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (Lurch)this.gidrah.getBehaviour();
        }
    }
}

