/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import invaders.Behaviour;
import invaders.Gidrah;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;

public class LeftRight
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private static final float DESCENT_FACTOR = 2.0f;
    private float direction = 1.0f;
    private float speed = 1.0f;
    private float descent = 0.0f;
    private boolean bounce;
    private boolean link;
    private boolean flip;
    private float yfreq;
    private float yamp;
    private transient float yOffset;
    private transient boolean flipNext;

    public LeftRight(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new LeftRightInstance(gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathLeftRight();
    }

    private static class LeftRightInstance
    extends Behaviour.Instance {
        private static final long serialVersionUID = 1L;
        float initialX;
        float initialY;
        boolean ignoreEdge;
        float direction;
        transient LeftRight behaviour;
        float yOffsetSerialized;

        public LeftRightInstance(Gidrah gidrah) {
            super(gidrah);
            this.behaviour = (LeftRight)gidrah.getBehaviour();
        }

        public void init() {
            this.initialX = this.gidrah.getX();
            this.initialY = this.gidrah.getY();
            this.behaviour.yOffset = 0.0f;
            this.direction = this.behaviour.direction;
            if (this.behaviour.flip && (this.gidrah.getInitialRow() & 1) == 1) {
                this.direction = -this.direction;
            }
        }

        public float getVX() {
            int numGidrahs = Gidrah.getGidrahs().size();
            float speedUp = this.behaviour.isBoss() ? 1.0f : (numGidrahs == 1 ? 4.0f : (numGidrahs == 2 ? 3.0f : (numGidrahs == 3 ? 2.0f : 1.0f)));
            return (this.behaviour.link ? this.behaviour.direction : this.direction) * this.behaviour.speed * speedUp;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (LeftRight)this.gidrah.getBehaviour();
            this.behaviour.yOffset = this.yOffsetSerialized;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.yOffsetSerialized = this.behaviour.yOffset;
            stream.defaultWriteObject();
        }

        protected void doTick() {
            int numGidrahs;
            if (this.behaviour.flipNext) {
                this.behaviour.flipNext = false;
                this.behaviour.direction = -this.behaviour.direction;
            }
            float speedUp = (numGidrahs = Gidrah.getGidrahs().size()) == 1 ? 3.0f : (numGidrahs <= 4 ? 2.0f : 1.0f);
            float x = this.gidrah.getX();
            float y = this.initialY + this.behaviour.yOffset + (float)Math.cos(Math.toDegrees(this.initialX + x * this.behaviour.yfreq)) * this.behaviour.yamp;
            float d = (this.behaviour.link ? this.behaviour.direction : this.direction) * this.behaviour.speed * speedUp;
            x += d;
            boolean descend = false;
            if (this.behaviour.bounce) {
                if (this.ignoreEdge) {
                    this.ignoreEdge = false;
                } else if (x < this.gidrah.getRadius() * 2.0f) {
                    if (this.behaviour.link) {
                        this.behaviour.flipNext = true;
                    } else {
                        this.direction = -this.direction;
                    }
                    descend = true;
                    this.ignoreEdge = true;
                } else if (x > (float)Game.getScale() - this.gidrah.getRadius() * 2.0f) {
                    if (this.behaviour.link) {
                        this.behaviour.flipNext = true;
                    } else {
                        this.direction = -this.direction;
                    }
                    descend = true;
                    this.ignoreEdge = true;
                }
            } else if (x < -this.gidrah.getRadius() * 2.0f) {
                x += (float)Game.getScale() + this.gidrah.getRadius() * 3.0f;
                this.initialY -= this.behaviour.descent + speedUp;
            } else if (x > (float)Game.getScale() + this.gidrah.getRadius() * 2.0f) {
                x -= (float)Game.getScale() + this.gidrah.getRadius() * 3.0f;
                this.initialY -= this.behaviour.descent + speedUp;
            }
            if (descend) {
                if (this.behaviour.link) {
                    LeftRight leftRight = this.behaviour;
                    leftRight.yOffset = leftRight.yOffset - (this.behaviour.descent * 2.0f + speedUp);
                } else {
                    this.initialY -= this.behaviour.descent * 2.0f + speedUp;
                }
            }
            this.gidrah.setLocation(x, y);
        }
    }
}

