/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.SFX;
import invaders.behaviours.Compass;
import invaders.behaviours.Pattern;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;

public class Galaxian
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private static int lastInitialRow = 0;
    private static final int PHASE_ARRIVAL = 0;
    private static final int PHASE_JOIN = 1;
    private static final int PHASE_FORMATION = 2;
    private static final int PHASE_START_DIVE = 3;
    private static final int PHASE_DIVE = 4;
    private static final int DELAY = 24;
    private static final int MIN_FORMATION_TIME = 60;
    private static final float START_DIVE_SEGMENT_DISTANCE = 4.0f;
    private static final int START_DIVE_SEGMENT_ANGLE = FPMath.SIXTEENTH;
    private static final int START_DIVE_SEGMENTS = 8;
    private static float formationOffsetX;
    private static float formationOffsetY;
    private static float originalOffsetX;
    private static float originalOffsetY;
    private static float targetOffsetX;
    private static float targetOffsetY;
    private static int formationTick;
    private static int formationDistance;
    private static final float FORMATION_SPEED = 0.25f;
    private static int MAX_OFFSET;
    private Range formationTime;
    private float speed;
    private Range dodgeTime;
    private int dodge;
    private transient int numGidrahs;

    static {
        MAX_OFFSET = 32;
    }

    public Galaxian(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new Instance(this, gidrah);
    }

    protected void doOnNewLevel() {
        super.doOnNewLevel();
        this.numGidrahs = 0;
    }

    public static void tickGalaxians() {
        if (++formationTick > formationDistance) {
            formationTick = 0;
            originalOffsetX = formationOffsetX;
            originalOffsetY = formationOffsetY;
            targetOffsetX = Util.random((int)(-MAX_OFFSET), (int)MAX_OFFSET);
            targetOffsetY = Util.random((int)(-MAX_OFFSET), (int)MAX_OFFSET) / 2;
            float dx = targetOffsetX - originalOffsetX;
            float dy = targetOffsetY - originalOffsetY;
            formationDistance = (int)(Math.sqrt(dx * dx + dy * dy) / 0.25);
        } else {
            float ratio = (float)formationTick / (float)formationDistance;
            formationOffsetX = LinearInterpolator.instance.interpolate(originalOffsetX, targetOffsetX, ratio);
            formationOffsetY = LinearInterpolator.instance.interpolate(originalOffsetY, targetOffsetY, ratio);
        }
    }

    public void deathNoise() {
        SFX.enemyDeathGalaxian();
    }

    private static class Instance
    extends Behaviour.Instance
    implements Compass {
        private static final long serialVersionUID = 1L;
        private transient Galaxian behaviour;
        private int phase;
        private int tick;
        private float distanceMovedSoFar;
        private int lastMoveIndex;
        private int segment;
        private float vx;
        private float formationX;
        private float formationY;
        private float joinX;
        private float joinY;
        private float joinTime;
        private transient Pattern pattern;

        public Instance(Galaxian behaviour, Gidrah gidrah) {
            super(gidrah);
            this.behaviour = behaviour;
            gidrah.setAutoRemove(false);
            if (lastInitialRow != gidrah.getInitialRow()) {
                lastInitialRow = gidrah.getInitialRow();
                this.pattern = Pattern.getNextPattern();
            } else {
                this.pattern = Pattern.getCurrentPattern();
            }
        }

        public void init() {
            super.init();
            this.formationX = this.gidrah.getX();
            this.formationY = this.gidrah.getY();
            this.gidrah.setLocation(this.pattern.getStartX(), this.pattern.getStartY());
            this.tick = (int)(-((float)(this.behaviour.numGidrahs * 24) / this.behaviour.speed));
            Galaxian galaxian = this.behaviour;
            galaxian.numGidrahs = galaxian.numGidrahs + 1;
        }

        protected void doTick() {
            switch (this.phase) {
                case 0: {
                    this.doTickArrival();
                    break;
                }
                case 1: {
                    this.doJoin();
                    break;
                }
                case 2: {
                    this.doTickFormation();
                    break;
                }
                case 3: {
                    this.doTickStartDive();
                    break;
                }
                case 4: {
                    this.doTickDive();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void doTickArrival() {
            ++this.tick;
            if (this.tick < 0) {
                return;
            }
            Pattern.Move move = this.pattern.getMoveAt(this.distanceMovedSoFar, this.lastMoveIndex);
            if (move == null) {
                this.joinFormation();
            } else {
                this.gidrah.setAngle(move.getAngle() + FPMath.QUARTER);
                float x = this.gidrah.getX();
                float y = this.gidrah.getY();
                double angleInRadians = (double)move.getAngle() * Math.PI / 32768.0;
                x = (float)((double)x + Math.cos(angleInRadians) * (double)this.behaviour.speed);
                if (x < -this.gidrah.getRadius() * 4.0f) {
                    x = (float)Game.getScale() + this.gidrah.getRadius() * 4.0f;
                } else if (x > (float)Game.getScale() + this.gidrah.getRadius() * 4.0f) {
                    x = (float)Game.getScale() + this.gidrah.getRadius() * 4.0f;
                }
                y = (float)((double)y + Math.sin(angleInRadians) * (double)this.behaviour.speed);
                this.gidrah.setLocation(x, y);
                this.distanceMovedSoFar += this.behaviour.speed;
                this.lastMoveIndex = move.getIndex();
            }
        }

        private void joinFormation() {
            this.gidrah.setAngle(0);
            this.phase = 1;
            this.joinX = this.gidrah.getX();
            this.joinY = this.gidrah.getY();
            float dx = this.formationX - this.joinX;
            float dy = this.formationY - this.joinY;
            double distance = Math.sqrt(dx * dx + dy * dy);
            this.joinTime = Math.max(1, (int)(distance / (double)this.behaviour.speed));
            this.tick = 0;
        }

        private void doJoin() {
            ++this.tick;
            float ratio = (float)this.tick / this.joinTime;
            float oldX = this.gidrah.getX();
            float oldY = this.gidrah.getY();
            float newX = LinearInterpolator.instance.interpolate(this.joinX, this.formationX + formationOffsetX, ratio);
            float newY = LinearInterpolator.instance.interpolate(this.joinY, this.formationY + formationOffsetY, ratio);
            double angle = Math.atan2(newY - oldY, newX - oldX);
            this.gidrah.setAngle(FPMath.fpYaklyDegrees((double)angle) + FPMath.QUARTER);
            this.gidrah.setLocation(newX, newY);
            if ((float)this.tick >= this.joinTime) {
                this.phase = 2;
                this.tick = Math.max(60, (int)this.behaviour.formationTime.getValue());
                this.gidrah.setAngle(0);
            }
        }

        private void doTickFormation() {
            this.tick = Gidrah.getGidrahs().size() < 5 ? (this.tick -= 10) : --this.tick;
            if (this.tick <= 0) {
                this.startDive();
            } else {
                this.gidrah.setLocation(this.formationX + formationOffsetX, this.formationY + formationOffsetY);
            }
        }

        private void startDive() {
            this.phase = 3;
            this.tick = 0;
            this.segment = 0;
        }

        private void doTickStartDive() {
            float x = this.gidrah.getX();
            float y = this.gidrah.getY();
            int angle = this.gidrah.getAngle();
            double angleInRadians = (double)(angle + FPMath.QUARTER) * Math.PI / 32768.0;
            x = (float)((double)x + Math.cos(angleInRadians) * (double)this.behaviour.speed);
            y = (float)((double)y + Math.sin(angleInRadians) * (double)this.behaviour.speed);
            this.gidrah.setLocation(x, y);
            ++this.tick;
            if ((float)this.tick >= 4.0f / this.behaviour.speed) {
                this.gidrah.setAngle(angle += START_DIVE_SEGMENT_ANGLE);
                ++this.segment;
                this.tick = 0;
                if (this.segment >= 8) {
                    this.phase = 4;
                    this.tick = (int)this.behaviour.dodgeTime.getValue();
                    this.vx = 0.0f;
                }
            }
        }

        private void doTickDive() {
            float oldX = this.gidrah.getX();
            float oldY = this.gidrah.getY();
            float newX = oldX + this.vx;
            float newY = oldY - this.behaviour.speed;
            if (newX < -this.gidrah.getRadius() * 4.0f) {
                newX = (float)Game.getScale() + this.gidrah.getRadius() * 4.0f;
            } else if (newX > (float)Game.getScale() + this.gidrah.getRadius() * 4.0f) {
                newX = -this.gidrah.getRadius() * 4.0f;
            }
            if (newY < -this.gidrah.getRadius() * 4.0f) {
                newY = (float)Game.getScale() + this.gidrah.getRadius() * 4.0f;
                this.gidrah.setLocation(newX, newY);
                if (Gidrah.getGidrahs().size() > 3) {
                    this.joinFormation();
                }
            } else {
                this.gidrah.setLocation(newX, newY);
                double angle = Math.atan2(newY - oldY, newX - oldX);
                this.gidrah.setAngle(FPMath.fpYaklyDegrees((double)angle) + FPMath.QUARTER);
                --this.tick;
                if (this.tick <= 0) {
                    this.tick = (int)this.behaviour.dodgeTime.getValue();
                    this.vx = GameScreen.getPlayer().getX() < this.gidrah.getX() ? Math.max(this.vx - this.behaviour.speed / 4.0f, -this.behaviour.speed) : Math.min(this.vx + this.behaviour.speed / 4.0f, this.behaviour.speed);
                }
            }
        }

        public float getVX() {
            return this.vx;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.pattern.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (Galaxian)this.gidrah.getBehaviour();
            try {
                this.pattern = (Pattern)Resources.get((String)stream.readUTF());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public void onDamaged() {
            if (this.phase == 2 && Math.random() < 0.5) {
                this.startDive();
            }
        }
    }
}

