/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.Resources;
import invaders.Behaviour;
import invaders.EnemyBullet;
import invaders.EnemyBulletFeature;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.LayersFeature;
import invaders.SFX;
import invaders.behaviours.Compass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;

public class Centipede
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private static int lastInitialRow = 0;
    private static int initialPosition;
    private static final int GRID_WIDTH = 40;
    private static final int GRID_HEIGHT = 40;
    private static final boolean[] GRID;
    private float speed;
    private int podTime;
    private String podAppearance;
    private String podBomb;
    private String podEmitter;
    private transient LayersFeature podAppearanceResource;
    private transient EnemyBulletFeature podBombFeature;
    private transient EmitterFeature podEmitterFeature;

    static {
        GRID = new boolean[1600];
    }

    private static int getQuantizedX(float x) {
        int gridSquareWidth = Game.getScale() / 40;
        int xx = (int)x + gridSquareWidth / 2;
        return xx /= gridSquareWidth;
    }

    private static int getQuantizedY(float y) {
        int gridSquareHeight = Game.getScale() / 40;
        int yy = (int)y + gridSquareHeight / 2;
        return yy /= gridSquareHeight;
    }

    private static boolean isPodAt(float x, float y) {
        int yy;
        int xx = Centipede.getQuantizedX(x);
        int idx = Centipede.getGridIndex(xx, yy = Centipede.getQuantizedY(y));
        if (idx == -1) {
            return false;
        }
        return GRID[idx];
    }

    private static int getGridIndex(int xx, int yy) {
        if (xx < 0 || xx >= 40 || yy < 0 || yy >= 40) {
            return -1;
        }
        return xx + yy * 40;
    }

    public Centipede(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new Instance(this, gidrah);
    }

    public static void reset() {
        Arrays.fill(GRID, false);
        initialPosition = 0;
        lastInitialRow = -1;
    }

    public void deathNoise() {
        SFX.enemyDeathCentipede();
    }

    private static class Instance
    extends Behaviour.Instance
    implements Compass {
        private static final long serialVersionUID = 1L;
        private transient Centipede behaviour;
        private float dx;
        private float descent;
        private int pos;

        public Instance(Centipede behaviour, Gidrah gidrah) {
            super(gidrah);
            this.behaviour = behaviour;
            this.dx = gidrah.getInitialRow() % 2 == 0 ? behaviour.speed : -behaviour.speed;
            gidrah.setAutoRemove(false);
            if (lastInitialRow != gidrah.getInitialRow()) {
                lastInitialRow = gidrah.getInitialRow();
                initialPosition = 1;
            } else {
                initialPosition = initialPosition + 1;
            }
            this.pos = initialPosition;
        }

        public void init() {
            float y = (float)Game.getScale() - 80.0f;
            float x = this.dx > 0.0f ? (float)(-this.pos) * this.gidrah.getRadius() * 2.0f : (float)Game.getScale() + (float)this.pos * this.gidrah.getRadius() * 2.0f;
            this.gidrah.setLocation(x, y);
        }

        protected void doTick() {
            float x = this.gidrah.getX();
            float y = this.gidrah.getY();
            if (this.descent > 0.0f) {
                y -= this.behaviour.speed * 2.0f;
                this.descent -= this.behaviour.speed * 2.0f;
                if (this.descent <= 0.0f) {
                    if (y < -this.gidrah.getRadius() * 2.0f) {
                        y = (float)Game.getScale() + this.gidrah.getRadius() * 2.0f;
                        this.descent = 0.0f;
                    } else if (y <= 10.0f + this.gidrah.getRadius()) {
                        this.descent = 100.0f;
                    } else if (Centipede.isPodAt(x, y)) {
                        this.descent = this.gidrah.getRadius() * 2.0f;
                    }
                }
            } else {
                float ddx = this.dx;
                if ((x += ddx) < this.gidrah.getRadius() && this.dx < 0.0f) {
                    this.descent = this.gidrah.getRadius() * 2.0f;
                    this.dx = -this.dx;
                    y -= this.behaviour.speed - (this.gidrah.getRadius() - x);
                    x = this.gidrah.getRadius();
                } else if (x > (float)Game.getScale() - this.gidrah.getRadius() && this.dx > 0.0f) {
                    this.descent = this.gidrah.getRadius() * 2.0f;
                    this.dx = -this.dx;
                    y -= this.behaviour.speed - (x - ((float)Game.getScale() - this.gidrah.getRadius()));
                    x = (float)Game.getScale() - this.gidrah.getRadius();
                } else if (Centipede.isPodAt(x + ddx, y)) {
                    this.descent = this.gidrah.getRadius() * 2.0f;
                    this.dx = -this.dx;
                    y -= this.behaviour.speed;
                }
            }
            this.gidrah.setLocation(x, y);
        }

        public void onDamaged() {
            if (Math.random() < 0.5) {
                this.morphIntoPod();
            }
        }

        public float getVX() {
            return this.dx;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.behaviour.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                this.behaviour = (Centipede)Resources.get((String)stream.readUTF());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        private void morphIntoPod() {
            this.gidrah.setBehaviour(new PodInstance(this.behaviour, this.gidrah, Centipede.getQuantizedX(this.gidrah.getX()), Centipede.getQuantizedY(this.gidrah.getY())));
        }
    }

    private static class PodInstance
    extends Behaviour.Instance
    implements Compass {
        private static final long serialVersionUID = 1L;
        private transient Centipede behaviour;
        private int gridx;
        private int gridy;
        private int tick;

        public PodInstance(Centipede behaviour, Gidrah gidrah, int gridx, int gridy) {
            super(gidrah);
            this.behaviour = behaviour;
            this.gridx = gridx;
            this.gridy = gridy;
            int idx = Centipede.getGridIndex(gridx, gridy);
            if (idx != -1) {
                GRID[idx] = true;
            }
            gidrah.requestSetAppearance(behaviour.podAppearanceResource);
            gidrah.setDontNoseDive(true);
        }

        protected void doTick() {
            ++this.tick;
            if (this.tick > this.behaviour.podTime) {
                Emitter emitter = this.behaviour.podEmitterFeature.spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.gidrah.getX(), this.gidrah.getY());
                EnemyBullet bomb = this.behaviour.podBombFeature.spawn(GameScreen.getInstance());
                bomb.setLocation(this.gidrah.getX(), this.gidrah.getY());
                this.gidrah.remove();
            }
        }

        protected void onRemove() {
            int idx = Centipede.getGridIndex(this.gridx, this.gridy);
            if (idx != -1) {
                GRID[idx] = false;
            }
        }

        public float getVX() {
            return 0.0f;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.behaviour.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                this.behaviour = (Centipede)Resources.get((String)stream.readUTF());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

