/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import invaders.Behaviour;
import invaders.Gidrah;
import invaders.SFX;
import invaders.behaviours.Compass;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;

public class Bounce
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private float speed;
    private int initialDirection = 1;
    private int rotation = 2;
    private boolean flip;

    public Bounce(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new BounceInstance(gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathBounce();
    }

    private static class BounceInstance
    extends Behaviour.Instance
    implements Compass {
        private static final long serialVersionUID = 1L;
        int direction;
        int rotation;
        float dx;
        float dy;
        boolean safetyX;
        boolean safetyY;
        transient Bounce behaviour;

        public BounceInstance(Gidrah gidrah) {
            super(gidrah);
            this.behaviour = (Bounce)gidrah.getBehaviour();
            this.direction = this.behaviour.initialDirection;
            this.rotation = this.behaviour.rotation;
            if (this.behaviour.flip && (gidrah.getInitialRow() & 1) == 1) {
                this.direction = (this.direction + this.rotation) % 8;
                this.rotation = -this.rotation;
            }
            this.dx = DX[this.direction];
            this.dy = DY[this.direction];
        }

        public float getVX() {
            int numGidrahs = Gidrah.getGidrahs().size();
            float speedUp = numGidrahs == 1 ? 3.0f : (numGidrahs <= 4 ? 2.0f : 1.0f);
            return speedUp * this.dx * this.behaviour.speed;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (Bounce)this.gidrah.getBehaviour();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        protected void doTick() {
            int numGidrahs = Gidrah.getGidrahs().size();
            float speedUp = numGidrahs == 1 ? 3.0f : (numGidrahs <= 4 ? 2.0f : 1.0f);
            float x = this.gidrah.getX();
            float y = this.gidrah.getY();
            float ddx = speedUp * this.dx * this.behaviour.speed;
            float ddy = speedUp * this.dy * this.behaviour.speed;
            if (ddx + x < this.gidrah.getRadius() * 2.0f || ddx + x > (float)Game.getScale() - this.gidrah.getRadius() * 2.0f) {
                if (!this.safetyX) {
                    this.dx = -this.dx;
                    ddx = -ddx;
                }
                this.safetyX = true;
            } else {
                this.safetyX = false;
            }
            if (ddy + y < this.gidrah.getRadius() * 2.0f + 10.0f || ddy + y > (float)Game.getScale() - (this.gidrah.getRadius() * 2.0f + 80.0f)) {
                if (!this.safetyY) {
                    this.dy = -this.dy;
                    ddy = -ddy;
                }
                this.safetyY = true;
            } else {
                this.safetyY = false;
            }
            this.gidrah.setLocation(x + ddx, y + ddy);
        }
    }
}

