/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import invaders.Entity;
import invaders.GameScreen;
import invaders.effects.SmartbombEffect;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.StrobeEffect;
import org.lwjgl.util.ReadableColor;

public class Smartbomb
extends Entity {
    private static final long serialVersionUID = 1L;
    public static final int DAMAGE = 30;
    private transient SmartbombEffect effect;

    public Smartbomb(float x, float y) {
        this.setLocation(x, y);
    }

    protected void doSpawn() {
        this.effect = new SmartbombEffect(this.getX(), this.getY());
        this.effect.spawn(GameScreen.getInstance());
        StrobeEffect strobe = new StrobeEffect(ReadableColor.WHITE, 60);
        strobe.spawn((Screen)GameScreen.getInstance());
    }

    protected void doRespawn() {
        this.remove();
    }

    protected void doRemove() {
        if (this.effect != null) {
            this.effect.remove();
            this.effect = null;
        }
    }

    protected void doTick() {
        if (!this.effect.isEffectActive()) {
            this.remove();
        }
    }

    public boolean canCollide() {
        return true;
    }

    public boolean canCollideWithLaser() {
        return false;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithSmartbomb(this);
    }

    public float getRadius() {
        return this.effect.getRadius();
    }
}

