/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import invaders.LayersFeature;
import invaders.ThingWithLayers;

public class SimpleThingWithLayers
implements ThingWithLayers {
    private static final long serialVersionUID = 1L;
    private final SpriteAllocator allocator;
    private Sprite[] sprite;
    private LayersFeature appearance;

    public SimpleThingWithLayers(SpriteAllocator allocator) {
        this.allocator = allocator;
    }

    public void requestSetAppearance(LayersFeature newAppearance) {
        if (this.appearance == newAppearance) {
            return;
        }
        this.appearance = newAppearance;
        if (this.appearance != null) {
            this.appearance.createSprites(this.allocator, this);
        } else {
            this.removeSprites();
        }
    }

    public LayersFeature getAppearance() {
        return this.appearance;
    }

    public Sprite getSprite(int idx) {
        return this.sprite[idx];
    }

    public Sprite[] getSprites() {
        return this.sprite;
    }

    public void setSprites(Sprite[] newSprites) {
        if (this.sprite != null) {
            this.removeSprites();
        }
        this.sprite = newSprites;
    }

    public void remove() {
        if (this.sprite != null) {
            this.removeSprites();
        }
    }

    private void removeSprites() {
        Sprite[] spriteArray = this.sprite;
        int n = this.sprite.length;
        int n2 = 0;
        while (n2 < n) {
            Sprite element = spriteArray[n2];
            if (element != null) {
                element.deallocate();
            }
            ++n2;
        }
        this.sprite = null;
    }
}

