/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import invaders.Invaders;
import invaders.InvadersGameState;
import invaders.ShopPowerDisplayFeature;
import invaders.ShopPrices;
import invaders.ShowPowerDisplay;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;

public class ShopScreen
extends Screen {
    public static final long serialVersionUID = 1L;
    private static ShopScreen instance;
    private static NumberFormat nf;
    private static final String BUY_SHIELDS = "buy_shields";
    private static final String BUY_GUN_POWER = "buy_gun_power";
    private static final String BUY_EXTRA_BULLETS = "buy_extra_bullets";
    private static final String BUY_SMARTBOMBS = "buy_smartbombs";
    private static final String BUY_ADDONS = "buy_addons";
    private static final String BUY_RECHARGE = "buy_recharge";
    private static final String CONTINUE = "continue";
    private static final String ADDON_GFX = "shop-tank-addon-";
    private static final String MONEY_BOUNDS = "money_bounds";
    private ShopPowerDisplayFeature shieldsDisplay;
    private ShopPowerDisplayFeature gunPowerDisplay;
    private ShopPowerDisplayFeature extraBulletsDisplay;
    private ShopPowerDisplayFeature smartBombsDisplay;
    private ShopPowerDisplayFeature addOnsDisplay;
    private ShopPowerDisplayFeature rechargeDisplay;
    private String moneyFont;
    private MappedColor moneyColor;
    private transient ShowPowerDisplay shieldsInstance;
    private transient ShowPowerDisplay gunPowerInstance;
    private transient ShowPowerDisplay extraBulletsInstance;
    private transient ShowPowerDisplay smartBombsInstance;
    private transient ShowPowerDisplay addOnsInstance;
    private transient ShowPowerDisplay rechargeInstance;
    private transient GLFont moneyFontResource;
    private transient GLString moneyLabel;
    private transient boolean mDown;
    private transient TickableObject tickableObject;

    static {
        nf = DecimalFormat.getIntegerInstance();
        nf.setGroupingUsed(true);
    }

    public ShopScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        instance = this;
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void doCreateScreen() {
        this.moneyLabel = new GLString(8);
        this.moneyLabel.setFont(this.moneyFontResource);
        this.moneyLabel.setColour((ReadableColor)this.moneyColor);
        this.shieldsDisplay.create();
        this.gunPowerDisplay.create();
        this.extraBulletsDisplay.create();
        this.smartBombsDisplay.create();
        this.addOnsDisplay.create();
        this.rechargeDisplay.create();
    }

    protected void onClicked(String id) {
        if (BUY_SHIELDS.equals(id)) {
            Invaders.getGameState().buyShields();
            this.updateBars();
        } else if (BUY_EXTRA_BULLETS.equals(id)) {
            Invaders.getGameState().buyExtraBullets();
            this.updateBars();
        } else if (BUY_GUN_POWER.equals(id)) {
            Invaders.getGameState().buyGunPower();
            this.updateBars();
        } else if (BUY_SMARTBOMBS.equals(id)) {
            Invaders.getGameState().buySmartBomb();
            this.updateBars();
        } else if (BUY_ADDONS.equals(id)) {
            Invaders.getGameState().buyAddOn();
            this.updateBars();
            this.updateAddons();
        } else if (BUY_RECHARGE.equals(id)) {
            Invaders.getGameState().buyRecharge();
            this.updateBars();
        } else if (CONTINUE.equals(id)) {
            Invaders.getGameState().nextLevel();
        }
    }

    protected void onOpen() {
        this.tickableObject = new TickableObject(){

            protected void render() {
                this.glRender(new GLRenderable(){

                    public void render() {
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
                    }
                });
                ShopScreen.this.moneyLabel.render((SimpleRenderer)this);
                ShopScreen.this.shieldsInstance.render((SimpleRenderer)this);
                ShopScreen.this.extraBulletsInstance.render((SimpleRenderer)this);
                ShopScreen.this.gunPowerInstance.render((SimpleRenderer)this);
                ShopScreen.this.smartBombsInstance.render((SimpleRenderer)this);
                ShopScreen.this.addOnsInstance.render((SimpleRenderer)this);
                ShopScreen.this.rechargeInstance.render((SimpleRenderer)this);
            }
        };
        this.tickableObject.setLayer(5);
        this.tickableObject.spawn((Screen)this);
        this.shieldsInstance = this.shieldsDisplay.spawn(this);
        this.extraBulletsInstance = this.extraBulletsDisplay.spawn(this);
        this.gunPowerInstance = this.gunPowerDisplay.spawn(this);
        this.smartBombsInstance = this.smartBombsDisplay.spawn(this);
        this.addOnsInstance = this.addOnsDisplay.spawn(this);
        this.rechargeInstance = this.rechargeDisplay.spawn(this);
        this.requestFocus(null);
        this.updateBars();
        this.updateAddons();
        this.onResized();
    }

    protected void doCleanup() {
        this.shieldsInstance.cleanup();
        this.extraBulletsInstance.cleanup();
        this.gunPowerInstance.cleanup();
        this.smartBombsInstance.cleanup();
        this.addOnsInstance.cleanup();
        this.rechargeInstance.cleanup();
        this.shieldsInstance = null;
        this.extraBulletsInstance = null;
        this.gunPowerInstance = null;
        this.smartBombsInstance = null;
        this.addOnsInstance = null;
        this.rechargeInstance = null;
        if (this.tickableObject != null) {
            this.tickableObject.remove();
            this.tickableObject = null;
        }
    }

    protected void onResized() {
        if (this.shieldsInstance != null) {
            this.shieldsInstance.onResized();
            this.extraBulletsInstance.onResized();
            this.gunPowerInstance.onResized();
            this.smartBombsInstance.onResized();
            this.addOnsInstance.onResized();
            this.rechargeInstance.onResized();
            ReadableRectangle moneyBounds = this.getArea(MONEY_BOUNDS).getBounds();
            this.moneyLabel.setLocation(moneyBounds.getX(), moneyBounds.getY());
        }
    }

    protected void doTick() {
        Keyboard.isKeyDown((int)50);
        this.mDown = false;
    }

    private void updateBars() {
        InvadersGameState gameState = Invaders.getGameState();
        this.getArea(BUY_SHIELDS).setEnabled(gameState.canBuyShields());
        this.getArea(BUY_EXTRA_BULLETS).setEnabled(gameState.canBuyExtraBullets());
        this.getArea(BUY_GUN_POWER).setEnabled(gameState.canBuyGunPower());
        this.getArea(BUY_SMARTBOMBS).setEnabled(gameState.canBuySmartBombs());
        this.getArea(BUY_ADDONS).setEnabled(gameState.canBuyAddOns());
        this.getArea(BUY_RECHARGE).setEnabled(gameState.canBuyRecharge());
        this.shieldsInstance.setUsed(gameState.getShields());
        this.extraBulletsInstance.setUsed(gameState.getExtraBullets());
        this.gunPowerInstance.setUsed(gameState.getGunPower());
        this.smartBombsInstance.setUsed(gameState.getSmartBombs());
        this.addOnsInstance.setUsed(gameState.getAddOn());
        this.rechargeInstance.setUsed(gameState.getShipSpeed());
        if (ShopPrices.SHIELDS[gameState.getShields()] == -1) {
            this.shieldsInstance.setPrice(-1);
        } else {
            this.shieldsInstance.setPrice(ShopPrices.SHIELDS[gameState.getShields()] * (1 + gameState.getLevel() / 100));
        }
        this.extraBulletsInstance.setPrice(ShopPrices.EXTRA_BULLETS[gameState.getExtraBullets()]);
        this.gunPowerInstance.setPrice(ShopPrices.GUN_POWER[gameState.getGunPower()]);
        if (gameState.getSmartBombs() == 3) {
            this.smartBombsInstance.setPrice(-1);
        } else {
            this.smartBombsInstance.setPrice(gameState.getSmartBombPrice());
        }
        this.addOnsInstance.setPrice(ShopPrices.ADDON[gameState.getAddOn()]);
        if (gameState.getAddOn() == 0) {
            this.rechargeInstance.setPrice(-1);
        } else {
            this.rechargeInstance.setPrice(ShopPrices.RECHARGE[gameState.getShipSpeed()]);
        }
        this.moneyLabel.setText("$" + nf.format(gameState.getMoney()));
    }

    private void updateAddons() {
        InvadersGameState gameState = Invaders.getGameState();
        int i = 1;
        while (i <= 4) {
            String addon = ADDON_GFX + i;
            if (this.getArea(addon) != null) {
                this.getArea(addon).setVisible(i <= gameState.getAddOn());
            }
            ++i;
        }
    }
}

