/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import invaders.Invaders;
import invaders.ShowPowerDisplay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.puppygames.applet.Anchor;
import net.puppygames.applet.Bounded;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public class ShopPowerDisplayFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private String[] barAnimation;
    private String unusedAnimation;
    private int gap;
    private Point location;
    private int layer;
    private int priceWidth;
    private Point offset;
    private float scale;
    private ArrayList<Anchor> anchors;
    private MappedColor priceColor;
    private MappedColor priceDisabledColor;
    private transient Animation[] barAnimationResource;
    private transient Animation unusedAnimationResource;

    public ShopPowerDisplayFeature() {
        this.setAutoCreated();
    }

    public ShopPowerDisplayFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        List anchorElements;
        super.load(element, loader);
        List bars = XMLUtil.getChildren((Element)element, (String)"bar");
        this.barAnimation = new String[bars.size()];
        int count = 0;
        for (Element barElement : bars) {
            String bar = XMLUtil.getText((Element)barElement, (String)"--missing bar animation--");
            this.barAnimation[count++] = bar;
        }
        if (this.priceWidth == 0) {
            this.offset = new Point();
        }
        if ((anchorElements = XMLUtil.getChildren((Element)element, (String)"anchor")).size() > 0) {
            this.anchors = new ArrayList(anchorElements.size());
            for (Element anchorChild : anchorElements) {
                Anchor anchor = (Anchor)loader.load(anchorChild);
                this.anchors.add(anchor);
            }
        }
    }

    protected void doCreate() {
        super.doCreate();
        this.barAnimationResource = new Animation[this.barAnimation.length];
        int i = 0;
        while (i < this.barAnimation.length) {
            this.barAnimationResource[i] = (Animation)Resources.get((String)this.barAnimation[i]);
            ++i;
        }
    }

    public ShowPowerDisplay spawn(final Screen screen) {
        ShowPowerDisplay ret = new ShowPowerDisplay(){
            Sprite[] sprite;
            GLString priceString;
            int x;
            int y;
            int used = -1;

            public ReadableRectangle getBounds() {
                return new Rectangle(this.x, this.y, 0, 0);
            }

            public void setBounds(int x, int y, int w, int h) {
                this.setLocation(x, y);
            }

            public void onResized() {
                if (ShopPowerDisplayFeature.this.anchors != null) {
                    for (Anchor anchor : ShopPowerDisplayFeature.this.anchors) {
                        anchor.apply((Bounded)this);
                    }
                } else if (ShopPowerDisplayFeature.this.location != null) {
                    boolean centreY;
                    boolean centreX = screen.isCentred() || screen.isCentredX();
                    boolean bl = centreY = screen.isCentred() || screen.isCentredY();
                    if (centreX || centreY) {
                        int newX = centreX ? (Game.getWidth() - Game.getScale()) / 2 + ShopPowerDisplayFeature.this.location.getX() : ShopPowerDisplayFeature.this.location.getX();
                        int newY = centreY ? (Game.getHeight() - Game.getScale()) / 2 + ShopPowerDisplayFeature.this.location.getY() : ShopPowerDisplayFeature.this.location.getY();
                        this.setLocation(newX, newY);
                    }
                }
            }

            public void setUsed(int used) {
                if (this.used == used) {
                    return;
                }
                this.used = used;
                int i = 0;
                while (i < Math.min(this.sprite.length, used)) {
                    this.sprite[i].setAnimation(ShopPowerDisplayFeature.this.barAnimationResource[i]);
                    ++i;
                }
                i = Math.max(0, used);
                while (i < this.sprite.length) {
                    this.sprite[i].setAnimation(ShopPowerDisplayFeature.this.unusedAnimationResource);
                    ++i;
                }
            }

            public void setLocation(int x, int y) {
                this.x = x;
                this.y = y;
                this.updatePriceLocation();
                Sprite[] spriteArray = this.sprite;
                int n = this.sprite.length;
                int n2 = 0;
                while (n2 < n) {
                    Sprite element = spriteArray[n2];
                    element.setLocation((float)(x + ShopPowerDisplayFeature.this.offset.getX()), (float)(y + ShopPowerDisplayFeature.this.offset.getY()));
                    x += ShopPowerDisplayFeature.this.gap;
                    ++n2;
                }
            }

            public void setPrice(int price) {
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                if (price == -1) {
                    this.priceString.setText("");
                } else {
                    this.priceString.setText("$" + price);
                }
                if (price > Invaders.getGameState().getMoney()) {
                    this.priceString.setColour((ReadableColor)ShopPowerDisplayFeature.this.priceDisabledColor);
                } else {
                    this.priceString.setColour((ReadableColor)ShopPowerDisplayFeature.this.priceColor);
                }
                this.updatePriceLocation();
            }

            private void updatePriceLocation() {
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                Rectangle bounds = this.priceString.getBounds(null);
                this.priceString.setLocation(this.x + ShopPowerDisplayFeature.this.priceWidth - bounds.getWidth(), this.y);
            }

            public void render(SimpleRenderer renderer) {
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                this.priceString.render(renderer);
            }

            public void init(Screen screen2) {
                this.sprite = new Sprite[ShopPowerDisplayFeature.this.barAnimation.length];
                int i = 0;
                while (i < this.sprite.length) {
                    this.sprite[i] = screen2.allocateSprite((Serializable)screen2);
                    if (this.sprite[i] == null) {
                        throw new RuntimeException("Ran out of sprites");
                    }
                    this.sprite[i].setLayer(ShopPowerDisplayFeature.this.layer);
                    this.sprite[i].setScale(FPMath.fpValue((float)ShopPowerDisplayFeature.this.scale));
                    ++i;
                }
                if (ShopPowerDisplayFeature.this.priceWidth == -1) {
                    return;
                }
                this.priceString = new GLString(6);
                this.priceString.setFont(Res.getTinyFont());
            }

            public void cleanup() {
                if (this.sprite == null) {
                    return;
                }
                Sprite[] spriteArray = this.sprite;
                int n = this.sprite.length;
                int n2 = 0;
                while (n2 < n) {
                    Sprite element = spriteArray[n2];
                    element.deallocate();
                    ++n2;
                }
                this.sprite = null;
            }
        };
        ret.init(screen);
        ret.setLocation(this.location.getX(), this.location.getY());
        ret.setUsed(0);
        return ret;
    }
}

