/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import invaders.Invaders;
import invaders.InvadersGameState;
import java.util.prefs.BackingStoreException;
import net.puppygames.applet.Game;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Screen;

public class SelectWorldScreen
extends Screen {
    private static SelectWorldScreen instance;
    private static final String ID_CANCEL = "cancel";
    private static final String[] WORLDS;

    static {
        WORLDS = new String[]{"EARTH", "THE MOON", "MARS", "SATURN", "TITAN"};
    }

    public SelectWorldScreen(String name) {
        super(name);
        this.setAutoCreated();
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show() {
        instance.open();
    }

    protected void onOpen() {
        int maxWorld = InvadersGameState.getMaxCheckpointWorld();
        int n = Math.min(5, maxWorld + 1);
        int i = 0;
        while (i < n) {
            this.setEnabled("world." + i, true);
            if (i > 0) {
                String node = String.valueOf(i * 20);
                try {
                    if (Game.getRoamingPreferences().nodeExists(node)) {
                        String info = String.valueOf(Game.getRoamingPreferences().node(node).getInt("checkpointScore", 0)) + " ";
                        info = String.valueOf(info) + "$" + Game.getRoamingPreferences().node(node).getInt("checkpointMoney", 0);
                        this.getArea("world." + i + ".cash").setText(info);
                        this.getArea("world." + i + ".shields").setText(String.valueOf(Game.getRoamingPreferences().node(node).getInt("checkpointShields", 0)));
                        this.getArea("world." + i + ".smarts").setText(String.valueOf(Game.getRoamingPreferences().node(node).getInt("checkpointSmartBombs", 0)));
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace(System.err);
                }
            }
            this.getArea("world." + i).setText(WORLDS[i]);
            ++i;
        }
        i = maxWorld + 1;
        while (i < 5) {
            this.setEnabled("world." + i, false);
            ++i;
        }
    }

    protected void onClicked(String id) {
        if (ID_CANCEL.equals(id)) {
            MiniGame.showTitleScreen();
        }
        if (id.startsWith("world.")) {
            int world = Integer.parseInt(id.substring(6));
            System.out.println("Start world " + world);
            Invaders.getGameState().init(world);
        }
    }
}

