/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.util.Util;
import invaders.Entity;
import invaders.GameScreen;
import invaders.LayersFeature;
import invaders.Powerup;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;

public abstract class PowerupFeature
extends Feature {
    private static final List POWERUPS = new ArrayList();
    private static final float FALL_SPEED = -2.0f;
    private static final int WAIT_DURATION = 145;
    private static final float ACCELERATION = 0.1f;
    private static int numPowerups;
    private String appearance;
    private String groundAppearance;
    private String collectEmitter;
    private transient LayersFeature appearanceResource;
    private transient LayersFeature groundAppearanceResource;
    private transient EmitterFeature collectEmitterFeature;

    public PowerupFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    protected void doRegister() {
        POWERUPS.add(this);
    }

    protected void doDeregister() {
        POWERUPS.remove((Object)this);
    }

    public static Powerup createRandom(Screen screen) {
        PowerupFeature pf = (PowerupFeature)((Object)POWERUPS.get(Util.random((int)0, (int)(POWERUPS.size() - 1))));
        Powerup ret = pf.createInstance();
        ret.spawn(screen);
        return ret;
    }

    protected abstract Powerup createInstance();

    public static int numPowerups() {
        return numPowerups;
    }

    protected static abstract class PowerupInstance
    extends Powerup {
        private static final long serialVersionUID = 1L;
        protected PowerupFeature feature;
        private boolean onFloor;
        private int tick;
        private float vy;

        protected PowerupInstance(PowerupFeature feature) {
            this.feature = feature;
            this.vy = -2.0f;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.feature.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                this.feature = (PowerupFeature)Resources.get((String)stream.readUTF());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        protected final void doSpawn() {
            this.requestSetAppearance(this.feature.appearanceResource);
            numPowerups = numPowerups + 1;
        }

        protected void doRespawn() {
            numPowerups = numPowerups + 1;
        }

        protected final void doRemove() {
            numPowerups = numPowerups - 1;
        }

        public final void onCollision(Entity entity) {
            entity.onCollisionWithPowerup(this);
        }

        protected final void pop() {
            SFX.collectPowerup();
            if (this.feature.collectEmitterFeature != null) {
                Emitter e = this.feature.collectEmitterFeature.spawn((Screen)GameScreen.getInstance());
                e.setLocation(this.getX(), this.getY());
            }
            this.remove();
        }

        protected final void doTick() {
            if (this.onFloor) {
                ++this.tick;
                if (this.tick > 145) {
                    this.pop();
                }
                return;
            }
            this.vy += 0.1f;
            float y = this.getY() - this.vy;
            if (y < 10.0f) {
                y = 10.0f;
                this.setLocation(this.getX(), y);
                this.onFloor = true;
                this.requestSetAppearance(this.feature.groundAppearanceResource);
            } else {
                this.setLocation(this.getX(), y);
            }
        }

        public boolean canCollide() {
            return true;
        }

        public boolean canCollideWithLaser() {
            return false;
        }

        public float getRadius() {
            return 8.0f;
        }
    }
}

