/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import invaders.Bullet;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Laser;
import invaders.Player;
import invaders.Res;
import invaders.SFX;
import invaders.Smartbomb;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class Parachute
extends Entity {
    private static final long serialVersionUID = 1L;
    private static int numParachutes;
    private static final float MAX_VY = -2.0f;
    private static final float ACCELERATION = 0.01f;
    private static final float DECELERATION = 0.99f;
    private static final float VX_RANGE = 1.0f;
    private static final int IMMUNE = 30;
    private float vx;
    private float vy;
    private int immune;
    private static final Color CAPTURE_BONUS_COLOR;

    static {
        CAPTURE_BONUS_COLOR = new Color(184, 255, 0, 200);
    }

    public Parachute(Gidrah source) {
        this.setLocation(source.getX(), source.getY());
        this.vx = (float)Math.random() * 1.0f * 2.0f - 1.0f;
        if (this.getX() < (float)Game.getScale() * 0.33f) {
            this.vx = Math.abs(this.vx);
        } else if (this.getX() > (float)Game.getScale() * 0.66f) {
            this.vx = -Math.abs(this.vx);
        }
        this.spawn(GameScreen.getInstance());
        this.immune = 30;
    }

    protected void doSpawn() {
        this.requestSetAppearance(Res.getParachuteLayers(Invaders.getGameState().getLevel() / 20));
        ++numParachutes;
    }

    protected void doRespawn() {
        ++numParachutes;
    }

    protected void doRemove() {
        --numParachutes;
    }

    public static int getNumParachutes() {
        return numParachutes;
    }

    public boolean canCollide() {
        return true;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithParachute(this);
    }

    public void onCollisionWithLaser(Laser laser) {
        if (this.immune > 0) {
            return;
        }
        this.kill();
    }

    public void onCollisionWithBullet(Bullet bullet) {
        if (this.immune > 0) {
            return;
        }
        this.kill();
    }

    public void onCollisionWithSmartbomb(Smartbomb smartBomb) {
        if (this.immune > 0) {
            return;
        }
        this.kill();
    }

    public void onCollisionWithPlayer(Player player) {
        this.capture();
    }

    private void kill() {
        Emitter e = Res.getParachuteExplosionEmitter().spawn((Screen)GameScreen.getInstance());
        e.setLocation(this.getX(), this.getY());
        LabelEffect effect = new LabelEffect(net.puppygames.applet.Res.getTinyFont(), "AARGH!", ReadableColor.WHITE, ReadableColor.RED, 45, 25);
        effect.spawn((Screen)GameScreen.getInstance());
        effect.setLocation((float)((int)this.getX()), (float)((int)this.getY()));
        effect.setVelocity(0.0f, 1.35f);
        effect.setAcceleration(0.0f, -0.025f);
        this.remove();
        Invaders.getGameState().onMurdered();
    }

    protected void doTick() {
        if (this.immune > 0) {
            --this.immune;
        }
        if (this.vy > -2.0f) {
            this.vy -= 0.01f;
        }
        this.vx *= 0.99f;
        this.setLocation(this.getX() + this.vx, this.getY() + this.vy);
    }

    private void capture() {
        int bonus = Invaders.getGameState().getLevel() / 20 * 50 + 100;
        LabelEffect effect = new LabelEffect(Res.getMessageFont(), "CAPTURE BONUS $" + bonus, ReadableColor.WHITE, (ReadableColor)CAPTURE_BONUS_COLOR, 55, 20);
        effect.spawn((Screen)GameScreen.getInstance());
        effect.setLocation((float)((int)this.getX()), 37.0f);
        effect.setVelocity(0.0f, -1.1f);
        effect.setAcceleration(0.0f, 0.02f);
        Invaders.getGameState().addMoney(bonus);
        Emitter e = Res.getParachuteCollectEmitter().spawn((Screen)GameScreen.getInstance());
        e.setLocation(this.getX(), this.getY());
        this.remove();
        Invaders.getGameState().bumpSaucer();
        Invaders.getGameState().onCaptured();
    }

    protected void onAutoRemove() {
        if (this.getY() <= 10.0f && this.getX() >= 0.0f && this.getX() < (float)Game.getScale()) {
            int penalty = Invaders.getGameState().getLevel() / 20 * 50 + 100;
            LabelEffect effect = new LabelEffect(Res.getMessageFont(), "ESCAPE PENALTY! -$" + penalty, ReadableColor.WHITE, ReadableColor.RED, 90, 30);
            effect.spawn((Screen)GameScreen.getInstance());
            effect.setLocation((float)((int)this.getX()), 0.0f);
            effect.setVelocity(0.0f, 0.5f);
            effect.setAcceleration(0.0f, -0.005f);
            SFX.missParachute();
            Invaders.getGameState().addMoney(-penalty);
            Invaders.getGameState().onEscaped();
        }
    }

    public float getRadius() {
        return 8.0f;
    }

    public boolean canCollideWithLaser() {
        return true;
    }
}

