/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ResourceArray;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import invaders.LayersFeature;
import invaders.ThingWithLayers;
import java.io.IOException;
import org.w3c.dom.Element;

public class NotifyCommand
extends Command {
    private String layer;
    private String i;
    private int idx;
    private String id;
    private transient Appearance appearance;

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.layer = element.getAttribute("layer");
        this.idx = -1;
        if (element.hasAttribute("i")) {
            this.i = element.getAttribute("i");
        } else if (element.hasAttribute("idx")) {
            this.idx = Integer.parseInt(element.getAttribute("idx"));
        }
        if (element.hasAttribute("id")) {
            this.id = element.getAttribute("id");
        }
    }

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        target.setSequence(currentSequence + 1);
        ThingWithLayers thingWithLayers = (ThingWithLayers)target.getOwner();
        LayersFeature layers = thingWithLayers.getAppearance();
        if (layers == null) {
            return true;
        }
        int layerIndex = layers.getLayer(this.layer);
        if (layerIndex != -1) {
            ResourceArray frameList;
            Sprite sprite = thingWithLayers.getSprite(layerIndex);
            if (sprite == target || sprite == null) {
                return true;
            }
            if (this.appearance != null && sprite.getAnimation() != this.appearance) {
                this.appearance.toSprite(sprite);
            } else if (this.idx != -1 && (frameList = sprite.getFrameList()) != null) {
                if (this.idx >= frameList.getNumResources() || this.idx < 0) {
                    System.err.println("Warning: index " + this.idx + " not present in " + frameList + " referenced by " + target + " on " + sprite);
                } else {
                    Appearance newAppearance = (Appearance)frameList.getResource(this.idx);
                    if (newAppearance != null) {
                        newAppearance.toSprite(sprite);
                    }
                }
            }
            if (this.id != null && sprite.getAnimation() != null) {
                int seq = sprite.getAnimation().getLabel(this.id);
                if (seq == -1) {
                    System.err.println("Warning: " + sprite.getAnimation() + " missing label " + this.id);
                } else {
                    sprite.setSequence(seq);
                }
            }
        }
        return true;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("layer", (Object)this.layer, true);
        writer.writeAttribute("i", (Object)this.i);
        writer.writeAttribute("idx", this.idx);
        writer.writeAttribute("id", (Object)this.id);
    }

    protected void doCreate() {
        if (this.i != null) {
            this.appearance = (Appearance)Resources.get((String)this.i);
        }
    }

    public void archive() {
        this.i = null;
    }

    protected void doDestroy() {
        this.appearance = null;
    }
}

