/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.util.XMLUtil;
import invaders.Background;
import invaders.Behaviour;
import invaders.Gidrah;
import invaders.Invaders;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.puppygames.applet.Game;
import org.w3c.dom.Element;

public class Level
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final List LEVELS = new ArrayList(100);
    private static final float BIG_GAP = 16.0f;
    private static final float SMALL_GAP = 4.0f;
    private static final int MIN_ALIEN_HEIGHT = 180;
    private String background;
    private int meteorFrequency;
    private List behaviours;
    private List barriers;
    private String[] rowData;
    private String boss;
    private transient Background backgroundResource;
    private transient int index;
    private transient Behaviour[][] row;
    private transient Behaviour bossFeature;

    public int getIndex() {
        return this.index;
    }

    protected void doRegister() {
        this.index = LEVELS.size();
        LEVELS.add(this);
    }

    protected void doCreate() {
        super.doCreate();
        this.row = new Behaviour[this.rowData.length][];
        int i = 0;
        while (i < this.rowData.length) {
            this.row[i] = new Behaviour[this.rowData[i].length()];
            int j = 0;
            while (j < this.rowData[i].length()) {
                char c = this.rowData[i].charAt(j);
                if (c == ' ' || c == '.') {
                    this.row[i][j] = Behaviour.BLANK;
                } else {
                    String behaviourName = (String)this.behaviours.get(c - 48);
                    this.row[i][j] = (Behaviour)Resources.get((String)behaviourName);
                }
                ++j;
            }
            ++i;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List gidrahs = XMLUtil.getChildren((Element)element, (String)"gidrah");
        this.behaviours = new ArrayList(gidrahs.size());
        for (Element gE : gidrahs) {
            this.behaviours.add(XMLUtil.getText((Element)gE, (String)"unknown_gidrah"));
        }
        List rowElements = XMLUtil.getChildren((Element)element, (String)"row");
        this.rowData = new String[rowElements.size()];
        int count = 0;
        for (Element rE : rowElements) {
            this.rowData[count++] = XMLUtil.getText((Element)rE, (String)"");
        }
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    protected void doDeregister() {
        LEVELS.remove((Object)this);
    }

    public List createGidrahs() {
        Behaviour.onNewLevel();
        LinkedList<Gidrah> ret = new LinkedList<Gidrah>();
        float y = (float)Game.getScale() - 80.0f;
        y -= (float)(Invaders.getGameState().getTotalMultiplier() / 100);
        y -= (float)Invaders.getGameState().getMultiplier();
        y = Math.max(180.0f, y);
        int i = 0;
        while (i < this.row.length) {
            float width = 0.0f;
            int n = this.row[i].length;
            Gidrah[] gidrahs = new Gidrah[n];
            int j = 0;
            while (j < n) {
                if (this.row[i][j] == Behaviour.BLANK) {
                    width += 16.0f;
                } else {
                    try {
                        Gidrah gidrah = new Gidrah(this.row[i][j], i);
                        ret.add(gidrah);
                        gidrahs[j] = gidrah;
                        if (j < n - 1) {
                            width += this.row[i][j].getGap() * 2.0f + 4.0f;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                ++j;
            }
            float x = ((float)Game.getScale() - width) / 2.0f;
            int j2 = 0;
            while (j2 < n) {
                if (gidrahs[j2] != null) {
                    gidrahs[j2].setLocation(x, y);
                    x += gidrahs[j2].getRadius() * 2.0f + 4.0f;
                } else {
                    x += 16.0f;
                }
                ++j2;
            }
            y -= 32.0f;
            ++i;
        }
        return ret;
    }

    public Background getBackground() {
        return this.backgroundResource;
    }

    public Behaviour getBoss() {
        return this.bossFeature;
    }

    public static Level getLevel(int level) {
        Level ret = (Level)((Object)LEVELS.get(level % 100));
        if (!ret.isCreated()) {
            try {
                ret.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return ret;
    }

    public int getMeteorFrequency() {
        return this.meteorFrequency;
    }
}

