/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Point2f;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import invaders.ThingWithLayers;
import java.io.Serializable;
import java.util.List;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadablePoint;
import org.w3c.dom.Element;

public class LayersFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private Layer[] sprite;
    private EmitterLayer[] emitter;
    private float scale = 1.0f;
    private Point offset;
    private float ySortOffset;
    private transient boolean hasColored;

    public LayersFeature() {
        this.setAutoCreated();
    }

    public LayersFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        List emitterLayerElements;
        super.load(element, loader);
        List layerElements = XMLUtil.getChildren((Element)element, (String)"sprite");
        if (layerElements.size() > 0) {
            this.sprite = new Layer[layerElements.size()];
            int count = 0;
            for (Element child : layerElements) {
                this.sprite[count] = new Layer();
                this.sprite[count].load(child, loader);
                ++count;
            }
        }
        if ((emitterLayerElements = XMLUtil.getChildren((Element)element, (String)"emitter")).size() > 0) {
            this.emitter = new EmitterLayer[emitterLayerElements.size()];
            int emitterCount = 0;
            for (Element child : emitterLayerElements) {
                this.emitter[emitterCount] = new EmitterLayer();
                this.emitter[emitterCount].load(child, loader);
                ++emitterCount;
            }
        }
    }

    protected void doCreate() {
        Feature element;
        int n;
        int n2;
        Feature[] featureArray;
        super.doCreate();
        if (this.sprite != null) {
            featureArray = this.sprite;
            n2 = this.sprite.length;
            n = 0;
            while (n < n2) {
                element = featureArray[n];
                element.create();
                if (((Layer)element).colored != null || ((Layer)element).topColored != null && ((Layer)element).bottomColored != null) {
                    this.hasColored = true;
                }
                ++n;
            }
        }
        if (this.emitter != null) {
            featureArray = this.emitter;
            n2 = this.emitter.length;
            n = 0;
            while (n < n2) {
                element = featureArray[n];
                element.create();
                ++n;
            }
        }
    }

    protected void doDestroy() {
        Feature element;
        int n;
        int n2;
        Feature[] featureArray;
        super.doDestroy();
        if (this.sprite != null) {
            featureArray = this.sprite;
            n2 = this.sprite.length;
            n = 0;
            while (n < n2) {
                element = featureArray[n];
                element.destroy();
                ++n;
            }
        }
        if (this.emitter != null) {
            featureArray = this.emitter;
            n2 = this.emitter.length;
            n = 0;
            while (n < n2) {
                element = featureArray[n];
                element.destroy();
                ++n;
            }
        }
    }

    public int getLayer(String id) {
        if (this.sprite == null) {
            return -1;
        }
        int i = 0;
        while (i < this.sprite.length) {
            if (id.equals(this.sprite[i].id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void createSprites(SpriteAllocator allocator, ThingWithLayers owner) {
        this.createSprites(allocator, 0.0f, 0.0f, owner);
    }

    public void createSprites(SpriteAllocator allocator, float mapX, float mapY, ThingWithLayers owner) {
        float oy;
        float ox;
        if (this.sprite == null) {
            owner.setSprites(new Sprite[0]);
            return;
        }
        Sprite[] s = new Sprite[this.sprite.length];
        if (this.offset != null) {
            ox = this.offset.getX();
            oy = this.offset.getY();
        } else {
            ox = 0.0f;
            oy = 0.0f;
        }
        int i = 0;
        while (i < s.length) {
            s[i] = allocator.allocateSprite((Serializable)owner);
            ++i;
        }
        owner.setSprites(s);
        i = 0;
        while (i < s.length) {
            if (this.sprite[i].animationResource != null) {
                s[i].setAnimation(this.sprite[i].animationResource);
            } else {
                s[i].setImage(this.sprite[i].imageResource);
            }
            s[i].setLayer(this.sprite[i].layer);
            s[i].setSubLayer(this.sprite[i].subLayer);
            s[i].setScale(FPMath.fpValue((float)this.scale));
            if (this.sprite[i].offset != null) {
                s[i].setOffset((this.sprite[i].offset.getX() + ox) * this.scale, (this.sprite[i].offset.getY() + oy) * this.scale);
            } else {
                s[i].setOffset(ox * this.scale, oy * this.scale);
            }
            s[i].setYSortOffset((this.ySortOffset + this.sprite[i].ySortOffset) * this.scale);
            if (this.sprite[i].doChildOffset) {
                s[i].setDoChildOffset(true);
            }
            ++i;
        }
    }

    public void updateLocation(Sprite[] existingSprite, float x, float y) {
        Sprite[] spriteArray = existingSprite;
        int n = existingSprite.length;
        int n2 = 0;
        while (n2 < n) {
            Sprite element = spriteArray[n2];
            element.setLocation(x, y);
            ++n2;
        }
    }

    public Emitter[] createEmitters(Screen screen, float x, float y) {
        if (this.emitter == null) {
            return new Emitter[0];
        }
        Emitter[] e = new Emitter[this.emitter.length];
        int i = 0;
        while (i < e.length) {
            if (this.emitter[i].emitterFeature != null) {
                float oy;
                float ox;
                e[i] = this.emitter[i].emitterFeature.spawn(screen);
                if (this.emitter[i].offset != null) {
                    ox = this.emitter[i].offset.getX() * this.scale;
                    oy = this.emitter[i].offset.getY() * this.scale;
                } else {
                    ox = 0.0f;
                    oy = 0.0f;
                }
                e[i].setLocation(x + ox, y + oy);
                e[i].setYOffset(this.emitter[i].ySortOffset * this.scale);
            }
            ++i;
        }
        return e;
    }

    public void updateEmitters(Emitter[] existingEmitters, float x, float y) {
        int i = 0;
        while (i < existingEmitters.length) {
            if (existingEmitters[i] != null) {
                float oy;
                float ox;
                if (this.emitter[i].offset != null) {
                    ox = this.emitter[i].offset.getX() * this.scale;
                    oy = this.emitter[i].offset.getY() * this.scale;
                } else {
                    ox = 0.0f;
                    oy = 0.0f;
                }
                existingEmitters[i].setLocation(x + ox, y + oy);
            }
            ++i;
        }
    }

    public void updateScale(Sprite[] existingSprites, float newScale) {
        int i = 0;
        while (i < existingSprites.length) {
            existingSprites[i].setScale(FPMath.fpValue((float)(newScale * this.scale)));
            if (this.sprite[i].offset != null) {
                existingSprites[i].setOffset(this.sprite[i].offset.getX() * newScale * this.scale, this.sprite[i].offset.getY() * newScale * this.scale);
            }
            existingSprites[i].setYSortOffset(this.sprite[i].ySortOffset * newScale * this.scale);
            ++i;
        }
    }

    public float getScale() {
        return this.scale;
    }

    public ReadablePoint getOffset() {
        return this.offset;
    }

    private static class EmitterLayer
    extends Feature {
        private String emitter;
        private Point2f offset;
        private float ySortOffset;
        private boolean doChildOffset;
        private transient EmitterFeature emitterFeature;

        public EmitterLayer() {
            this.setAutoCreated();
            this.setSubResource(true);
        }
    }

    private static class Layer
    extends Feature {
        private String id;
        private int layer;
        private int subLayer;
        private Point2f offset;
        private float ySortOffset;
        private String animation;
        private String image;
        private boolean doChildOffset;
        private MappedColor colored;
        private MappedColor topColored;
        private MappedColor bottomColored;
        private transient Animation animationResource;
        private transient SpriteImage imageResource;

        public Layer() {
            this.setAutoCreated();
            this.setSubResource(true);
        }
    }
}

